/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.transformer.Transformation;
import com.gsl.xslt2java.transformer.compiler.TransformerPatternCompiler;
import com.gsl.xslt2java.transformer.compiler.TransformerPatternLexer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class ExpressionTransformer {
    private final List<Transformation> patterns = new ArrayList<Transformation>();
    public static final String PATTERN_FILE_PATH = "patternFilePath";

    protected ExpressionTransformer(List<Transformation> patterns) {
        this.patterns.addAll(patterns);
    }

    public ExpressionTransformer(String filePath) {
        this(new File(filePath));
    }

    private static TransformerPatternCompiler makeParser(InputStream is) throws IOException {
        TransformerPatternLexer lexer = new TransformerPatternLexer((CharStream)new ANTLRInputStream(is));
        return new TransformerPatternCompiler((TokenStream)new CommonTokenStream((TokenSource)lexer));
    }

    public ExpressionTransformer(File f) {
        try {
            TransformerPatternCompiler patternCompiler = ExpressionTransformer.makeParser(new FileInputStream(f));
            this.patterns.addAll(patternCompiler.compilePatterns());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ExpressionTransformer(InputStream is) {
        try {
            TransformerPatternCompiler patternCompiler = ExpressionTransformer.makeParser(is);
            this.patterns.addAll(patternCompiler.compilePatterns());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addTransforms(Transformation[] specialTransforms) {
        for (Transformation specialOpt : specialTransforms) {
            this.patterns.add(specialOpt);
        }
    }

    protected void addPattern(String pattern) throws RecognitionException, IOException {
        this.patterns.add(ExpressionTransformer.compilePattern(pattern));
    }

    public TransformationResult transform(Expression e) {
        TransformationResult result = new TransformationResult();
        result.expression = e;
        for (Transformation element : this.patterns) {
            Transformation pattern = element;
            if (!pattern.matches(result.expression)) continue;
            result.expression = pattern.apply(result.expression);
            result.patternMatched = true;
        }
        return result;
    }

    protected static Transformation compilePattern(String pattern) throws RecognitionException, IOException {
        TransformerPatternCompiler patternCompiler = ExpressionTransformer.makeParser(new ByteArrayInputStream(pattern.getBytes()));
        return patternCompiler.compilePattern();
    }

    public class TransformationResult {
        public Expression expression;
        public boolean patternMatched = false;
    }
}

