/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer.optimizations;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.LocationPathExpression;
import com.gsl.xslt2java.expression.binary.EqualsExpression;
import com.gsl.xslt2java.expression.special.MatchPreceding;
import com.gsl.xslt2java.transformer.Transformation;
import com.gsl.xslt2java.xpath.Axis;
import com.gsl.xslt2java.xpath.LocationPath;
import com.gsl.xslt2java.xpath.LocationPathStep;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;

public class MatchPrecedingOpt
implements Transformation {
    @Override
    public MatchPreceding apply(Expression e) {
        LocationPathExpression lpe = (LocationPathExpression)e;
        LocationPath mainPathIn = lpe.getPath();
        LocationPath mainPathOut = new LocationPath();
        for (LocationPathStep step : mainPathIn.getSteps()) {
            mainPathOut.appendStep(step.clone());
        }
        EqualsExpression predicate = (EqualsExpression)lpe.getPath().getLastStep().getPredicate();
        LocationPathExpression lhs = (LocationPathExpression)predicate.getLhs();
        return new MatchPreceding(mainPathOut, lhs.getPath());
    }

    @Override
    public boolean matches(Expression e) {
        boolean result = false;
        if (e instanceof LocationPathExpression) {
            EqualsExpression be;
            LocationPathExpression lpe = (LocationPathExpression)e;
            Expression predicate = lpe.getPath().getLastStep().getPredicate();
            if (lpe.getPath().getFirstStep().getAxis() == Axis.PRECEDING_SIBLING && predicate != null && predicate instanceof EqualsExpression && (be = (EqualsExpression)predicate).getLhs() instanceof LocationPathExpression && be.getRhs() instanceof LocationPathExpression) {
                LocationPathExpression lhs = (LocationPathExpression)be.getLhs();
                LocationPathExpression rhs = (LocationPathExpression)be.getRhs();
                if (lhs.getPath().isRelative() && rhs.getPath().isRelative()) {
                    long rCount;
                    long lCount;
                    LocationPath lPath = lhs.getPath();
                    LocationPath rPath = rhs.getPath();
                    if (!lPath.isComplex() && !rPath.isComplex() && (lCount = lPath.getStepCount()) == (rCount = rPath.getStepCount()) - 1L && rPath.getFirstStep() instanceof XSLTCurrentStep) {
                        result = true;
                        int i = 1;
                        for (LocationPathStep lStep : lPath.getSteps()) {
                            result &= rPath.getSteps().get(i++).equals(lStep);
                        }
                    }
                }
            }
        }
        return result;
    }
}

