/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer.pattern;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.binary.BinaryExpression;
import com.gsl.xslt2java.transformer.pattern.PatternNode;

public class BinaryOpPattern
implements PatternNode {
    private final String operator;
    private final PatternNode lhs;
    private final PatternNode rhs;

    public BinaryOpPattern(String operator, PatternNode lhs, PatternNode rhs) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public boolean matches(Expression e) {
        boolean result = false;
        if (BinaryExpression.class.isAssignableFrom(e.getClass())) {
            BinaryExpression be = (BinaryExpression)e;
            result = this.operator.equals(be.getOperator()) && this.lhs.matches(be.getLhs()) && this.rhs.matches(be.getRhs());
        }
        return result;
    }

    public String toString() {
        return "BinaryOp(" + this.operator + ", " + this.lhs + ", " + this.rhs + ")";
    }
}

