/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer.pattern;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.binary.EqualsExpression;
import com.gsl.xslt2java.transformer.pattern.PatternNode;

public class EqualsPattern
implements PatternNode {
    private PatternNode lhs;
    private PatternNode rhs;

    @Override
    public boolean matches(Expression e) {
        boolean result = false;
        if (EqualsExpression.class.isAssignableFrom(e.getClass())) {
            EqualsExpression ee = (EqualsExpression)e;
            result = this.lhs.matches(ee.getLhs()) && this.rhs.matches(ee.getRhs());
        }
        return result;
    }

    public PatternNode getLhs() {
        return this.lhs;
    }

    public void setLhs(PatternNode lhs) {
        this.lhs = lhs;
    }

    public PatternNode getRhs() {
        return this.rhs;
    }

    public void setRhs(PatternNode rhs) {
        this.rhs = rhs;
    }

    public String toString() {
        return "Equals(" + this.lhs + ", " + this.rhs + ")";
    }
}

