/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer.pattern;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.FunctionCall;
import com.gsl.xslt2java.transformer.pattern.PatternNode;
import java.util.List;

public class FunctionCallPattern
implements PatternNode {
    private String scope = "";
    private String name;
    private List<PatternNode> parameters;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PatternNode> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<PatternNode> parameters) {
        this.parameters = parameters;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public boolean matches(Expression e) {
        FunctionCall f;
        boolean result = false;
        if (FunctionCall.class.isAssignableFrom(e.getClass()) && (f = (FunctionCall)e).getScope().equals(this.getScope()) && f.getName().equals(this.getName()) && f.getParameters().size() == this.getParameters().size()) {
            boolean matches = true;
            for (int i = 0; i < this.getParameters().size() && matches; ++i) {
                Expression expressionParam = f.getParameters().get(i);
                PatternNode patternParam = this.getParameters().get(i);
                if (patternParam.matches(expressionParam)) continue;
                matches = false;
            }
            result = matches;
        }
        return result;
    }

    public String toString() {
        String result = "FunctionCall " + this.name + "(";
        boolean first = true;
        for (PatternNode param : this.getParameters()) {
            if (!first) {
                result = result + ",";
            }
            result = result + param.toString();
            first = false;
        }
        return result;
    }
}

