/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer.pattern;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.MethodCall;
import com.gsl.xslt2java.transformer.pattern.PatternNode;
import java.util.List;

public class MethodCallPattern
implements PatternNode {
    private final PatternNode object;
    private final String name;
    private final List<PatternNode> parameters;

    public MethodCallPattern(PatternNode object, String name, List<PatternNode> paramList) {
        this.object = object;
        this.name = name;
        this.parameters = paramList;
    }

    @Override
    public boolean matches(Expression e) {
        MethodCall mc;
        boolean result = false;
        if (MethodCall.class.isAssignableFrom(e.getClass()) && this.object.matches((mc = (MethodCall)e).getObject()) && this.name.equals(mc.getMethodName())) {
            boolean matches = true;
            for (int i = 0; i < this.getParameters().size() && matches; ++i) {
                Expression expressionParam = mc.getParameters().get(i);
                PatternNode patternParam = this.getParameters().get(i);
                if (patternParam.matches(expressionParam)) continue;
                matches = false;
            }
            result = matches;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public PatternNode getObject() {
        return this.object;
    }

    public List<PatternNode> getParameters() {
        return this.parameters;
    }
}

