/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.transformer.pattern;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.UnaryExpression;
import com.gsl.xslt2java.transformer.pattern.PatternNode;

public class UnaryOpPattern
implements PatternNode {
    private final String operator;
    private final PatternNode rhs;

    public UnaryOpPattern(String operator, PatternNode rhs) {
        this.operator = operator;
        this.rhs = rhs;
    }

    @Override
    public boolean matches(Expression e) {
        boolean result = false;
        if (UnaryExpression.class.isAssignableFrom(e.getClass())) {
            UnaryExpression ue = (UnaryExpression)e;
            result = this.operator.equals(ue.getOp()) && this.rhs.matches(ue.getRhs());
        }
        return result;
    }

    public String toString() {
        return "UnaryOp(" + this.operator + ", " + this.rhs + ")";
    }
}

