/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.xpath;

import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.FunctionCall;
import com.gsl.xslt2java.expression.emitter.XPathEmitter;
import com.gsl.xslt2java.statement.PredicateClassDefinition;
import com.gsl.xslt2java.xpath.Axis;
import com.gsl.xslt2java.xpath.LocationPathStep;

public abstract class AbstractPathStep
implements LocationPathStep {
    private String namespacePrefix = "";
    private Expression predicate = null;
    private final PredicateClassDefinition predicateStatement = null;
    private Axis axis = null;

    @Override
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Override
    public void setNamespacePrefix(String namespacePrefix) {
        if (namespacePrefix == null) {
            throw new IllegalArgumentException("trying to set namespace prefix to null");
        }
        this.namespacePrefix = namespacePrefix;
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("implement equals for " + this.getClass());
    }

    public int hashCode() {
        throw new UnsupportedOperationException("implement hashCode for " + this.getClass());
    }

    @Override
    public LocationPathStep clone() {
        throw new UnsupportedOperationException("implement clone for " + this.getClass());
    }

    public String toString() {
        String result = this.asString();
        if (this.axis != null) {
            result = (Object)((Object)this.axis) + "::" + result;
        }
        if (this.predicate != null) {
            result = result + "[" + XPathEmitter.asXPath(this.predicate) + "]";
        }
        return result;
    }

    public abstract String asString();

    @Override
    public Expression getPredicate() {
        return this.predicate;
    }

    @Override
    public void setPredicate(Expression predicate) {
        this.predicate = predicate;
    }

    protected void clone(AbstractPathStep clone) {
        clone.namespacePrefix = this.namespacePrefix;
    }

    @Override
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    @Override
    public boolean hasNestedPredicates() {
        return this.predicate != null && this.predicate.hasPredicates();
    }

    public boolean hasComplexPredicate() {
        return this.predicate instanceof FunctionCall;
    }

    @Override
    public boolean hasPredicates() {
        return this.predicate != null;
    }

    @Override
    public boolean isComplex() {
        return this.axis != null && this.axis.isComplex() || this.hasNestedPredicates() || this.hasComplexPredicate();
    }
}

