/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.xslt2java.xpath;

import com.gsl.xslt2java.XPathToJavaTranslator;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.IntegerLiteral;
import com.gsl.xslt2java.expression.emitter.PredicateEmitter;
import com.gsl.xslt2java.statement.PredicateClassDefinition;
import com.gsl.xslt2java.statement.Statement;
import com.gsl.xslt2java.xpath.AttributeStep;
import com.gsl.xslt2java.xpath.Axis;
import com.gsl.xslt2java.xpath.ChildElementsStep;
import com.gsl.xslt2java.xpath.ElementStep;
import com.gsl.xslt2java.xpath.LocationPathStep;
import com.gsl.xslt2java.xpath.NameTestStep;
import com.gsl.xslt2java.xpath.ParentElementStep;
import com.gsl.xslt2java.xpath.PathError;
import com.gsl.xslt2java.xpath.RootStep;
import com.gsl.xslt2java.xpath.SelfNodeStep;
import com.gsl.xslt2java.xpath.TextNodeTest;
import com.gsl.xslt2java.xpath.XSLTCurrentStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LocationPath
implements Cloneable {
    private final List<LocationPathStep> steps = new ArrayList<LocationPathStep>();
    private ArrayList<Statement> supportingStatements = null;
    private PredicateClassDefinition trailingPredicateStatement;
    private int cachedHashCode = -1;

    public LocationPath clone() {
        LocationPath clonedPath = new LocationPath();
        for (LocationPathStep step : this.steps) {
            clonedPath.appendStep(step.clone());
        }
        return clonedPath;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass().equals(this.getClass())) {
            LocationPath that = (LocationPath)other;
            if (this.stepCount() == that.stepCount()) {
                boolean stepsAreEqual = true;
                for (int i = 0; i < this.stepCount() && stepsAreEqual; ++i) {
                    stepsAreEqual = stepsAreEqual && this.steps.get(i).equals(that.steps.get(i));
                }
                result = stepsAreEqual;
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.cachedHashCode == -1) {
            this.cachedHashCode = 0;
            for (LocationPathStep step : this.steps) {
                this.cachedHashCode ^= step.hashCode();
            }
        }
        return this.cachedHashCode;
    }

    public LocationPath(LocationPathStep firstStep) {
        this.steps.add(firstStep);
    }

    public LocationPath(String pathString) {
        this(XPathToJavaTranslator.parseLocationPath(pathString));
    }

    public LocationPath(LocationPath pathToCopy) {
        this.steps.addAll(pathToCopy.steps);
    }

    public LocationPath() {
    }

    public int stepCount() {
        return this.steps.size();
    }

    public String asPathString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (LocationPathStep step : this.steps) {
            if (!first) {
                result.append("/");
            }
            first = false;
            Axis axis = step.getAxis();
            if (axis != null) {
                result.append((Object)axis).append("::");
            }
            result.append(step.getQualifiedPathName());
            Expression predicate = step.getPredicate();
            if (predicate == null) continue;
            result.append("[").append(PredicateEmitter.asPredicate(predicate)).append("]");
        }
        return result.toString();
    }

    public String getEffectivePathString() {
        return this.getEffectivePath().asPathString();
    }

    public LocationPath getEffectivePath() {
        LocationPath result = new LocationPath();
        boolean first = true;
        for (LocationPathStep nextStep : this.steps) {
            Axis axis = nextStep.getAxis();
            if (axis != null && axis == Axis.PRECEDING_SIBLING) {
                result.appendStep(new ParentElementStep());
            }
            if (result.stepCount() > 0 && nextStep instanceof XSLTCurrentStep && result.getLastStep() instanceof AttributeStep) {
                result.dropLastStep();
            }
            if (nextStep instanceof TextNodeTest) {
                if (first) {
                    result.appendStep(new SelfNodeStep());
                }
            } else if (nextStep instanceof ChildElementsStep) {
                if (first) {
                    result.appendStep(new SelfNodeStep());
                } else {
                    result.appendStep(nextStep.clone());
                }
            } else {
                result.appendStep(nextStep.clone());
            }
            first = false;
        }
        return result;
    }

    private void dropLastStep() {
        assert (this.stepCount() > 0) : "Attempted to drop last step of an empty path";
        this.steps.remove(this.stepCount() - 1);
    }

    public void appendStep(LocationPathStep step) {
        if (step instanceof ElementStep && step.getAxis() == Axis.ATTRIBUTE) {
            Expression predicate = step.getPredicate();
            step = new AttributeStep(step.getNamespacePrefix(), step.getName());
            step.setPredicate(predicate);
        }
        this.steps.add(step);
    }

    public void appendPath(LocationPath path) {
        if (path.isRelative()) {
            for (LocationPathStep step : path.steps) {
                this.appendStep(step);
            }
        } else {
            throw new PathError("Cannot append absolute path to another path");
        }
    }

    public boolean isComplex() {
        boolean result = false;
        for (LocationPathStep step : this.steps) {
            if (!step.isComplex()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasNestedPredicates() {
        boolean result = false;
        for (LocationPathStep step : this.steps) {
            if (!step.hasNestedPredicates()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasPredicates() {
        boolean result = false;
        for (LocationPathStep step : this.steps) {
            if (!step.hasPredicates()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public boolean usesCurrent() {
        return this.getFirstStep() instanceof XSLTCurrentStep;
    }

    public boolean isAbsolute() {
        return this.getFirstStep() instanceof RootStep;
    }

    public LocationPathStep getFirstStep() {
        return this.steps.size() > 0 ? this.steps.get(0) : null;
    }

    public String toString() {
        return this.asPathString();
    }

    public List<Statement> getSupportingStatements() {
        if (this.supportingStatements == null) {
            this.supportingStatements = new ArrayList();
            PredicateClassDefinition predicateStatement = this.getTrailingPredicateStatement();
            if (predicateStatement != null) {
                this.supportingStatements.addAll(predicateStatement.getExpression().getSupportingStatements());
                this.supportingStatements.add(predicateStatement);
            }
        }
        return this.supportingStatements;
    }

    LocationPath subPath(LocationPathStep lastStep) {
        LocationPath subPath = new LocationPath();
        for (LocationPathStep step : this.steps) {
            subPath.appendStep(step.clone());
            if (step != lastStep) continue;
            break;
        }
        return subPath;
    }

    public LocationPathStep getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    public LocationPathStep getLastNameTest() {
        LocationPathStep lastNameTest = null;
        for (LocationPathStep step : this.steps) {
            if (!(step instanceof NameTestStep)) continue;
            lastNameTest = step;
        }
        return lastNameTest;
    }

    public List<LocationPathStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public Expression getPredicateForStep(LocationPathStep lastStep) {
        throw new UnsupportedOperationException("implement me!");
    }

    public String getTrailingPredicateIdentifier() {
        return this.getTrailingPredicateStatement().getInstanceName();
    }

    private PredicateClassDefinition getTrailingPredicateStatement() {
        Expression predicate;
        if (this.trailingPredicateStatement == null && (predicate = this.getLastStep().getPredicate()) != null && !(predicate instanceof IntegerLiteral)) {
            this.trailingPredicateStatement = new PredicateClassDefinition(predicate, this);
        }
        return this.trailingPredicateStatement;
    }

    public LocationPath resolve(LocationPath path) {
        if (path.isAbsolute()) {
            return path;
        }
        LocationPath startingPoint = new LocationPath(this);
        startingPoint.appendPath(path);
        return startingPoint.getEffectivePath();
    }

    public long getStepCount() {
        return this.steps.size();
    }
}

