/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.base.BaseDuration;
import org.joda.time.field.FieldUtils;

public final class Duration
extends BaseDuration
implements ReadableDuration,
Serializable {
    public static final Duration ZERO = new Duration(0L);
    private static final long serialVersionUID = 2471658376918L;

    public static Duration standardDays(long days) {
        if (days == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(days, 86400000));
    }

    public static Duration standardHours(long hours) {
        if (hours == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(hours, 3600000));
    }

    public static Duration standardMinutes(long minutes) {
        if (minutes == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(minutes, 60000));
    }

    public static Duration standardSeconds(long seconds) {
        if (seconds == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(seconds, 1000));
    }

    public Duration(long duration) {
        super(duration);
    }

    public Duration(long startInstant, long endInstant) {
        super(startInstant, endInstant);
    }

    public Duration(ReadableInstant start, ReadableInstant end) {
        super(start, end);
    }

    public Duration(Object duration) {
        super(duration);
    }

    public long getStandardSeconds() {
        return this.getMillis() / 1000L;
    }

    @Override
    public Duration toDuration() {
        return this;
    }

    public Seconds toStandardSeconds() {
        long seconds = this.getStandardSeconds();
        return Seconds.seconds(FieldUtils.safeToInt(seconds));
    }

    public Duration withMillis(long duration) {
        if (duration == this.getMillis()) {
            return this;
        }
        return new Duration(duration);
    }

    public Duration withDurationAdded(long durationToAdd, int scalar) {
        if (durationToAdd == 0L || scalar == 0) {
            return this;
        }
        long add = FieldUtils.safeMultiply(durationToAdd, scalar);
        long duration = FieldUtils.safeAdd(this.getMillis(), add);
        return new Duration(duration);
    }

    public Duration withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        return this.withDurationAdded(durationToAdd.getMillis(), scalar);
    }

    public Duration plus(long amount) {
        return this.withDurationAdded(amount, 1);
    }

    public Duration plus(ReadableDuration amount) {
        if (amount == null) {
            return this;
        }
        return this.withDurationAdded(amount.getMillis(), 1);
    }

    public Duration minus(long amount) {
        return this.withDurationAdded(amount, -1);
    }

    public Duration minus(ReadableDuration amount) {
        if (amount == null) {
            return this;
        }
        return this.withDurationAdded(amount.getMillis(), -1);
    }
}

