/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalTime
extends BaseLocal
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = -12873158713873L;
    public static final LocalTime MIDNIGHT = new LocalTime(0, 0, 0, 0);
    private static final int HOUR_OF_DAY = 0;
    private static final int MINUTE_OF_HOUR = 1;
    private static final int SECOND_OF_MINUTE = 2;
    private static final int MILLIS_OF_SECOND = 3;
    private static final Set TIME_DURATION_TYPES = new HashSet();
    private long iLocalMillis;
    private Chronology iChronology;

    public static LocalTime fromMillisOfDay(long millisOfDay) {
        return LocalTime.fromMillisOfDay(millisOfDay, null);
    }

    public static LocalTime fromMillisOfDay(long millisOfDay, Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono).withUTC();
        return new LocalTime(millisOfDay, chrono);
    }

    public static LocalTime fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new LocalTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static LocalTime fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new LocalTime(date.getHours(), date.getMinutes(), date.getSeconds(), ((int)(date.getTime() % 1000L) + 1000) % 1000);
    }

    public LocalTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalTime(DateTimeZone zone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(zone));
    }

    public LocalTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public LocalTime(long instant) {
        this(instant, (Chronology)ISOChronology.getInstance());
    }

    public LocalTime(long instant, DateTimeZone zone) {
        this(instant, (Chronology)ISOChronology.getInstance(zone));
    }

    public LocalTime(long instant, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        long localMillis = chronology.getZone().getMillisKeepLocal(DateTimeZone.UTC, instant);
        chronology = chronology.withUTC();
        this.iLocalMillis = chronology.millisOfDay().get(localMillis);
        this.iChronology = chronology;
    }

    public LocalTime(Object instant) {
        this(instant, (Chronology)null);
    }

    public LocalTime(Object instant, DateTimeZone zone) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        Chronology chronology = converter.getChronology(instant, zone);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] values = converter.getPartialValues(this, instant, chronology, ISODateTimeFormat.localTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, values[0], values[1], values[2], values[3]);
    }

    public LocalTime(Object instant, Chronology chronology) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        chronology = converter.getChronology(instant, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] values = converter.getPartialValues(this, instant, chronology, ISODateTimeFormat.localTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, values[0], values[1], values[2], values[3]);
    }

    public LocalTime(int hourOfDay, int minuteOfHour) {
        this(hourOfDay, minuteOfHour, 0, 0, ISOChronology.getInstanceUTC());
    }

    public LocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        this(hourOfDay, minuteOfHour, secondOfMinute, 0, ISOChronology.getInstanceUTC());
    }

    public LocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this(hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ISOChronology.getInstanceUTC());
    }

    public LocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology).withUTC();
        long instant = chronology.getDateTimeMillis(0L, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.iChronology = chronology;
        this.iLocalMillis = instant;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.hourOfDay();
            }
            case 1: {
                return chrono.minuteOfHour();
            }
            case 2: {
                return chrono.secondOfMinute();
            }
            case 3: {
                return chrono.millisOfSecond();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int getValue(int index) {
        switch (index) {
            case 0: {
                return this.getChronology().hourOfDay().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().minuteOfHour().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().secondOfMinute().get(this.getLocalMillis());
            }
            case 3: {
                return this.getChronology().millisOfSecond().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int get(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        return fieldType.getField(this.getChronology()).get(this.getLocalMillis());
    }

    @Override
    public boolean isSupported(DateTimeFieldType type) {
        if (type == null) {
            return false;
        }
        if (!this.isSupported(type.getDurationType())) {
            return false;
        }
        DurationFieldType range = type.getRangeDurationType();
        return this.isSupported(range) || range == DurationFieldType.days();
    }

    public boolean isSupported(DurationFieldType type) {
        if (type == null) {
            return false;
        }
        DurationField field = type.getField(this.getChronology());
        if (TIME_DURATION_TYPES.contains(type) || field.getUnitMillis() < this.getChronology().days().getUnitMillis()) {
            return field.isSupported();
        }
        return false;
    }

    @Override
    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    public boolean equals(Object partial) {
        if (this == partial) {
            return true;
        }
        if (partial instanceof LocalTime) {
            LocalTime other = (LocalTime)partial;
            if (this.iChronology.equals(other.iChronology)) {
                return this.iLocalMillis == other.iLocalMillis;
            }
        }
        return super.equals(partial);
    }

    @Override
    public int compareTo(Object partial) {
        if (this == partial) {
            return 0;
        }
        if (partial instanceof LocalTime) {
            LocalTime other = (LocalTime)partial;
            if (this.iChronology.equals(other.iChronology)) {
                return this.iLocalMillis < other.iLocalMillis ? -1 : (this.iLocalMillis == other.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(partial);
    }

    LocalTime withLocalMillis(long newMillis) {
        return newMillis == this.getLocalMillis() ? this : new LocalTime(newMillis, this.getChronology());
    }

    public LocalTime withFields(ReadablePartial partial) {
        if (partial == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(partial, this.getLocalMillis()));
    }

    public LocalTime withField(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        long instant = fieldType.getField(this.getChronology()).set(this.getLocalMillis(), value);
        return this.withLocalMillis(instant);
    }

    public LocalTime withFieldAdded(DurationFieldType fieldType, int amount) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        if (amount == 0) {
            return this;
        }
        long instant = fieldType.getField(this.getChronology()).add(this.getLocalMillis(), amount);
        return this.withLocalMillis(instant);
    }

    public LocalTime withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(period, this.getLocalMillis(), scalar);
        return this.withLocalMillis(instant);
    }

    public LocalTime plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public LocalTime plusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        long instant = this.getChronology().hours().add(this.getLocalMillis(), hours);
        return this.withLocalMillis(instant);
    }

    public LocalTime plusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        long instant = this.getChronology().minutes().add(this.getLocalMillis(), minutes);
        return this.withLocalMillis(instant);
    }

    public LocalTime plusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        long instant = this.getChronology().seconds().add(this.getLocalMillis(), seconds);
        return this.withLocalMillis(instant);
    }

    public LocalTime plusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        long instant = this.getChronology().millis().add(this.getLocalMillis(), millis);
        return this.withLocalMillis(instant);
    }

    public LocalTime minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public LocalTime minusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        long instant = this.getChronology().hours().subtract(this.getLocalMillis(), hours);
        return this.withLocalMillis(instant);
    }

    public LocalTime minusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        long instant = this.getChronology().minutes().subtract(this.getLocalMillis(), minutes);
        return this.withLocalMillis(instant);
    }

    public LocalTime minusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        long instant = this.getChronology().seconds().subtract(this.getLocalMillis(), seconds);
        return this.withLocalMillis(instant);
    }

    public LocalTime minusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        long instant = this.getChronology().millis().subtract(this.getLocalMillis(), millis);
        return this.withLocalMillis(instant);
    }

    public Property property(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        return new Property(this, fieldType.getField(this.getChronology()));
    }

    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public LocalTime withHourOfDay(int hour) {
        return this.withLocalMillis(this.getChronology().hourOfDay().set(this.getLocalMillis(), hour));
    }

    public LocalTime withMinuteOfHour(int minute) {
        return this.withLocalMillis(this.getChronology().minuteOfHour().set(this.getLocalMillis(), minute));
    }

    public LocalTime withSecondOfMinute(int second) {
        return this.withLocalMillis(this.getChronology().secondOfMinute().set(this.getLocalMillis(), second));
    }

    public LocalTime withMillisOfSecond(int millis) {
        return this.withLocalMillis(this.getChronology().millisOfSecond().set(this.getLocalMillis(), millis));
    }

    public LocalTime withMillisOfDay(int millis) {
        return this.withLocalMillis(this.getChronology().millisOfDay().set(this.getLocalMillis(), millis));
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public DateTime toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public DateTime toDateTimeToday(DateTimeZone zone) {
        Chronology chrono = this.getChronology().withZone(zone);
        long instantMillis = DateTimeUtils.currentTimeMillis();
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.time().print(this);
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    static {
        TIME_DURATION_TYPES.add(DurationFieldType.millis());
        TIME_DURATION_TYPES.add(DurationFieldType.seconds());
        TIME_DURATION_TYPES.add(DurationFieldType.minutes());
        TIME_DURATION_TYPES.add(DurationFieldType.hours());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -325842547277223L;
        private transient LocalTime iInstant;
        private transient DateTimeField iField;

        Property(LocalTime instant, DateTimeField field) {
            this.iInstant = instant;
            this.iField = field;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.iInstant);
            oos.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
            this.iInstant = (LocalTime)oos.readObject();
            DateTimeFieldType type = (DateTimeFieldType)oos.readObject();
            this.iField = type.getField(this.iInstant.getChronology());
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public LocalTime getLocalTime() {
            return this.iInstant;
        }

        public LocalTime addCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), value));
        }

        public LocalTime addCopy(long value) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), value));
        }

        public LocalTime addNoWrapToCopy(int value) {
            long millis = this.iField.add(this.iInstant.getLocalMillis(), value);
            long rounded = this.iInstant.getChronology().millisOfDay().get(millis);
            if (rounded != millis) {
                throw new IllegalArgumentException("The addition exceeded the boundaries of LocalTime");
            }
            return this.iInstant.withLocalMillis(millis);
        }

        public LocalTime addWrapFieldToCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), value));
        }

        public LocalTime setCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), value));
        }

        public LocalTime setCopy(String text, Locale locale) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), text, locale));
        }

        public LocalTime setCopy(String text) {
            return this.setCopy(text, null);
        }

        public LocalTime withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public LocalTime withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public LocalTime roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }
    }
}

