/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BasePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;

public final class Period
extends BasePeriod
implements ReadablePeriod,
Serializable {
    public static final Period ZERO = new Period();
    private static final long serialVersionUID = 741052353876488155L;

    public static Period years(int years) {
        return new Period(new int[]{years, 0, 0, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period months(int months) {
        return new Period(new int[]{0, months, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period weeks(int weeks) {
        return new Period(new int[]{0, 0, weeks, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period days(int days) {
        return new Period(new int[]{0, 0, 0, days, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period hours(int hours) {
        return new Period(new int[]{0, 0, 0, 0, hours, 0, 0, 0}, PeriodType.standard());
    }

    public static Period minutes(int minutes) {
        return new Period(new int[]{0, 0, 0, 0, 0, minutes, 0, 0}, PeriodType.standard());
    }

    public static Period seconds(int seconds) {
        return new Period(new int[]{0, 0, 0, 0, 0, 0, seconds, 0}, PeriodType.standard());
    }

    public static Period millis(int millis) {
        return new Period(new int[]{0, 0, 0, 0, 0, 0, 0, millis}, PeriodType.standard());
    }

    public static Period fieldDifference(ReadablePartial start, ReadablePartial end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (start.size() != end.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        DurationFieldType[] types = new DurationFieldType[start.size()];
        int[] values = new int[start.size()];
        int isize = start.size();
        for (int i = 0; i < isize; ++i) {
            if (start.getFieldType(i) != end.getFieldType(i)) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            types[i] = start.getFieldType(i).getDurationType();
            if (i > 0 && types[i - 1] == types[i]) {
                throw new IllegalArgumentException("ReadablePartial objects must not have overlapping fields");
            }
            values[i] = end.getValue(i) - start.getValue(i);
        }
        return new Period(values, PeriodType.forFields(types));
    }

    public Period() {
        super(0L, (PeriodType)null, (Chronology)null);
    }

    public Period(int hours, int minutes, int seconds, int millis) {
        super(0, 0, 0, 0, hours, minutes, seconds, millis, PeriodType.standard());
    }

    public Period(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        super(years, months, weeks, days, hours, minutes, seconds, millis, PeriodType.standard());
    }

    public Period(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, PeriodType type) {
        super(years, months, weeks, days, hours, minutes, seconds, millis, type);
    }

    public Period(long duration) {
        super(duration, (PeriodType)null, (Chronology)null);
    }

    public Period(long duration, PeriodType type) {
        super(duration, type, (Chronology)null);
    }

    public Period(long duration, Chronology chronology) {
        super(duration, (PeriodType)null, chronology);
    }

    public Period(long duration, PeriodType type, Chronology chronology) {
        super(duration, type, chronology);
    }

    public Period(long startInstant, long endInstant) {
        super(startInstant, endInstant, null, null);
    }

    public Period(long startInstant, long endInstant, PeriodType type) {
        super(startInstant, endInstant, type, null);
    }

    public Period(long startInstant, long endInstant, Chronology chrono) {
        super(startInstant, endInstant, null, chrono);
    }

    public Period(long startInstant, long endInstant, PeriodType type, Chronology chrono) {
        super(startInstant, endInstant, type, chrono);
    }

    public Period(ReadableInstant startInstant, ReadableInstant endInstant) {
        super(startInstant, endInstant, null);
    }

    public Period(ReadableInstant startInstant, ReadableInstant endInstant, PeriodType type) {
        super(startInstant, endInstant, type);
    }

    public Period(ReadablePartial start, ReadablePartial end) {
        super(start, end, null);
    }

    public Period(ReadablePartial start, ReadablePartial end, PeriodType type) {
        super(start, end, type);
    }

    public Period(ReadableInstant startInstant, ReadableDuration duration) {
        super(startInstant, duration, null);
    }

    public Period(ReadableInstant startInstant, ReadableDuration duration, PeriodType type) {
        super(startInstant, duration, type);
    }

    public Period(ReadableDuration duration, ReadableInstant endInstant) {
        super(duration, endInstant, null);
    }

    public Period(ReadableDuration duration, ReadableInstant endInstant, PeriodType type) {
        super(duration, endInstant, type);
    }

    public Period(Object period) {
        super(period, null, null);
    }

    public Period(Object period, PeriodType type) {
        super(period, type, null);
    }

    public Period(Object period, Chronology chrono) {
        super(period, null, chrono);
    }

    public Period(Object period, PeriodType type, Chronology chrono) {
        super(period, type, chrono);
    }

    private Period(int[] values, PeriodType type) {
        super(values, type);
    }

    @Override
    public Period toPeriod() {
        return this;
    }

    public int getYears() {
        return this.getPeriodType().getIndexedField(this, PeriodType.YEAR_INDEX);
    }

    public int getMonths() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MONTH_INDEX);
    }

    public int getWeeks() {
        return this.getPeriodType().getIndexedField(this, PeriodType.WEEK_INDEX);
    }

    public int getDays() {
        return this.getPeriodType().getIndexedField(this, PeriodType.DAY_INDEX);
    }

    public int getHours() {
        return this.getPeriodType().getIndexedField(this, PeriodType.HOUR_INDEX);
    }

    public int getMinutes() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MINUTE_INDEX);
    }

    public int getSeconds() {
        return this.getPeriodType().getIndexedField(this, PeriodType.SECOND_INDEX);
    }

    public int getMillis() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MILLI_INDEX);
    }

    public Period withPeriodType(PeriodType type) {
        if ((type = DateTimeUtils.getPeriodType(type)).equals(this.getPeriodType())) {
            return this;
        }
        return new Period((Object)this, type);
    }

    public Period withFields(ReadablePeriod period) {
        if (period == null) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = super.mergePeriodInto(newValues, period);
        return new Period(newValues, this.getPeriodType());
    }

    public Period withField(DurationFieldType field, int value) {
        if (field == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        int[] newValues = this.getValues();
        super.setFieldInto(newValues, field, value);
        return new Period(newValues, this.getPeriodType());
    }

    public Period withFieldAdded(DurationFieldType field, int value) {
        if (field == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (value == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        super.addFieldInto(newValues, field, value);
        return new Period(newValues, this.getPeriodType());
    }

    public Period withYears(int years) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.YEAR_INDEX, values, years);
        return new Period(values, this.getPeriodType());
    }

    public Period withMonths(int months) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MONTH_INDEX, values, months);
        return new Period(values, this.getPeriodType());
    }

    public Period withWeeks(int weeks) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.WEEK_INDEX, values, weeks);
        return new Period(values, this.getPeriodType());
    }

    public Period withDays(int days) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.DAY_INDEX, values, days);
        return new Period(values, this.getPeriodType());
    }

    public Period withHours(int hours) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.HOUR_INDEX, values, hours);
        return new Period(values, this.getPeriodType());
    }

    public Period withMinutes(int minutes) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MINUTE_INDEX, values, minutes);
        return new Period(values, this.getPeriodType());
    }

    public Period withSeconds(int seconds) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.SECOND_INDEX, values, seconds);
        return new Period(values, this.getPeriodType());
    }

    public Period withMillis(int millis) {
        int[] values = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MILLI_INDEX, values, millis);
        return new Period(values, this.getPeriodType());
    }

    public Period plus(ReadablePeriod period) {
        if (period == null) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, values, period.get(DurationFieldType.YEARS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, values, period.get(DurationFieldType.MONTHS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, values, period.get(DurationFieldType.WEEKS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, values, period.get(DurationFieldType.DAYS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, values, period.get(DurationFieldType.HOURS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, values, period.get(DurationFieldType.MINUTES_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, values, period.get(DurationFieldType.SECONDS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, values, period.get(DurationFieldType.MILLIS_TYPE));
        return new Period(values, this.getPeriodType());
    }

    public Period plusYears(int years) {
        if (years == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, values, years);
        return new Period(values, this.getPeriodType());
    }

    public Period plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, values, months);
        return new Period(values, this.getPeriodType());
    }

    public Period plusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, values, weeks);
        return new Period(values, this.getPeriodType());
    }

    public Period plusDays(int days) {
        if (days == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, values, days);
        return new Period(values, this.getPeriodType());
    }

    public Period plusHours(int hours) {
        if (hours == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, values, hours);
        return new Period(values, this.getPeriodType());
    }

    public Period plusMinutes(int minutes) {
        if (minutes == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, values, minutes);
        return new Period(values, this.getPeriodType());
    }

    public Period plusSeconds(int seconds) {
        if (seconds == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, values, seconds);
        return new Period(values, this.getPeriodType());
    }

    public Period plusMillis(int millis) {
        if (millis == 0) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, values, millis);
        return new Period(values, this.getPeriodType());
    }

    public Period minus(ReadablePeriod period) {
        if (period == null) {
            return this;
        }
        int[] values = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, values, -period.get(DurationFieldType.YEARS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, values, -period.get(DurationFieldType.MONTHS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, values, -period.get(DurationFieldType.WEEKS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, values, -period.get(DurationFieldType.DAYS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, values, -period.get(DurationFieldType.HOURS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, values, -period.get(DurationFieldType.MINUTES_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, values, -period.get(DurationFieldType.SECONDS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, values, -period.get(DurationFieldType.MILLIS_TYPE));
        return new Period(values, this.getPeriodType());
    }

    public Period minusYears(int years) {
        return this.plusYears(-years);
    }

    public Period minusMonths(int months) {
        return this.plusMonths(-months);
    }

    public Period minusWeeks(int weeks) {
        return this.plusWeeks(-weeks);
    }

    public Period minusDays(int days) {
        return this.plusDays(-days);
    }

    public Period minusHours(int hours) {
        return this.plusHours(-hours);
    }

    public Period minusMinutes(int minutes) {
        return this.plusMinutes(-minutes);
    }

    public Period minusSeconds(int seconds) {
        return this.plusSeconds(-seconds);
    }

    public Period minusMillis(int millis) {
        return this.plusMillis(-millis);
    }

    public Weeks toStandardWeeks() {
        this.checkYearsAndMonths("Weeks");
        long millis = this.getMillis();
        millis += (long)this.getSeconds() * 1000L;
        millis += (long)this.getMinutes() * 60000L;
        millis += (long)this.getHours() * 3600000L;
        long weeks = (long)this.getWeeks() + (millis += (long)this.getDays() * 86400000L) / 604800000L;
        return Weeks.weeks(FieldUtils.safeToInt(weeks));
    }

    public Days toStandardDays() {
        this.checkYearsAndMonths("Days");
        long millis = this.getMillis();
        millis += (long)this.getSeconds() * 1000L;
        millis += (long)this.getMinutes() * 60000L;
        long days = (millis += (long)this.getHours() * 3600000L) / 86400000L;
        days = FieldUtils.safeAdd(days, (long)this.getDays());
        days = FieldUtils.safeAdd(days, (long)this.getWeeks() * 7L);
        return Days.days(FieldUtils.safeToInt(days));
    }

    public Hours toStandardHours() {
        this.checkYearsAndMonths("Hours");
        long millis = this.getMillis();
        millis += (long)this.getSeconds() * 1000L;
        long hours = (millis += (long)this.getMinutes() * 60000L) / 3600000L;
        hours = FieldUtils.safeAdd(hours, (long)this.getHours());
        hours = FieldUtils.safeAdd(hours, (long)this.getDays() * 24L);
        hours = FieldUtils.safeAdd(hours, (long)this.getWeeks() * 168L);
        return Hours.hours(FieldUtils.safeToInt(hours));
    }

    public Minutes toStandardMinutes() {
        this.checkYearsAndMonths("Minutes");
        long millis = this.getMillis();
        long minutes = (millis += (long)this.getSeconds() * 1000L) / 60000L;
        minutes = FieldUtils.safeAdd(minutes, (long)this.getMinutes());
        minutes = FieldUtils.safeAdd(minutes, (long)this.getHours() * 60L);
        minutes = FieldUtils.safeAdd(minutes, (long)this.getDays() * 1440L);
        minutes = FieldUtils.safeAdd(minutes, (long)this.getWeeks() * 10080L);
        return Minutes.minutes(FieldUtils.safeToInt(minutes));
    }

    public Seconds toStandardSeconds() {
        this.checkYearsAndMonths("Seconds");
        long seconds = this.getMillis() / 1000;
        seconds = FieldUtils.safeAdd(seconds, (long)this.getSeconds());
        seconds = FieldUtils.safeAdd(seconds, (long)this.getMinutes() * 60L);
        seconds = FieldUtils.safeAdd(seconds, (long)this.getHours() * 3600L);
        seconds = FieldUtils.safeAdd(seconds, (long)this.getDays() * 86400L);
        seconds = FieldUtils.safeAdd(seconds, (long)this.getWeeks() * 604800L);
        return Seconds.seconds(FieldUtils.safeToInt(seconds));
    }

    public Duration toStandardDuration() {
        this.checkYearsAndMonths("Duration");
        long millis = this.getMillis();
        millis += (long)this.getSeconds() * 1000L;
        millis += (long)this.getMinutes() * 60000L;
        millis += (long)this.getHours() * 3600000L;
        millis += (long)this.getDays() * 86400000L;
        return new Duration(millis += (long)this.getWeeks() * 604800000L);
    }

    private void checkYearsAndMonths(String destintionType) {
        if (this.getMonths() != 0) {
            throw new UnsupportedOperationException("Cannot convert to " + destintionType + " as this period contains months and months vary in length");
        }
        if (this.getYears() != 0) {
            throw new UnsupportedOperationException("Cannot convert to " + destintionType + " as this period contains years and years vary in length");
        }
    }

    public Period normalizedStandard() {
        return this.normalizedStandard(PeriodType.standard());
    }

    public Period normalizedStandard(PeriodType type) {
        long millis = this.getMillis();
        millis += (long)this.getSeconds() * 1000L;
        millis += (long)this.getMinutes() * 60000L;
        millis += (long)this.getHours() * 3600000L;
        millis += (long)this.getDays() * 86400000L;
        Period result = new Period(millis += (long)this.getWeeks() * 604800000L, DateTimeUtils.getPeriodType(type), (Chronology)ISOChronology.getInstanceUTC());
        int years = this.getYears();
        int months = this.getMonths();
        if (years != 0 || months != 0) {
            years = FieldUtils.safeAdd(years, months / 12);
            months %= 12;
            if (years != 0) {
                result = result.withYears(years);
            }
            if (months != 0) {
                result = result.withMonths(months);
            }
        }
        return result;
    }
}

