/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

class BasicMonthOfYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -8258715387168736L;
    private static final int MIN = 1;
    private final BasicChronology iChronology;
    private final int iMax;
    private final int iLeapMonth;

    BasicMonthOfYearDateTimeField(BasicChronology chronology, int leapMonth) {
        super(DateTimeFieldType.monthOfYear(), chronology.getAverageMillisPerMonth());
        this.iChronology = chronology;
        this.iMax = this.iChronology.getMaxMonth();
        this.iLeapMonth = leapMonth;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getMonthOfYear(instant);
    }

    @Override
    public long add(long instant, int months) {
        int yearToUse;
        if (months == 0) {
            return instant;
        }
        long timePart = this.iChronology.getMillisOfDay(instant);
        int thisYear = this.iChronology.getYear(instant);
        int thisMonth = this.iChronology.getMonthOfYear(instant, thisYear);
        int monthToUse = thisMonth - 1 + months;
        if (monthToUse >= 0) {
            yearToUse = thisYear + monthToUse / this.iMax;
            monthToUse = monthToUse % this.iMax + 1;
        } else {
            yearToUse = thisYear + monthToUse / this.iMax - 1;
            int remMonthToUse = (monthToUse = Math.abs(monthToUse)) % this.iMax;
            if (remMonthToUse == 0) {
                remMonthToUse = this.iMax;
            }
            if ((monthToUse = this.iMax - remMonthToUse + 1) == 1) {
                ++yearToUse;
            }
        }
        int dayToUse = this.iChronology.getDayOfMonth(instant, thisYear, thisMonth);
        int maxDay = this.iChronology.getDaysInYearMonth(yearToUse, monthToUse);
        if (dayToUse > maxDay) {
            dayToUse = maxDay;
        }
        long datePart = this.iChronology.getYearMonthDayMillis(yearToUse, monthToUse, dayToUse);
        return datePart + timePart;
    }

    @Override
    public long add(long instant, long months) {
        int maxDay;
        long yearToUse;
        int i_months = (int)months;
        if ((long)i_months == months) {
            return this.add(instant, i_months);
        }
        long timePart = this.iChronology.getMillisOfDay(instant);
        int thisYear = this.iChronology.getYear(instant);
        int thisMonth = this.iChronology.getMonthOfYear(instant, thisYear);
        long monthToUse = (long)(thisMonth - 1) + months;
        if (monthToUse >= 0L) {
            yearToUse = (long)thisYear + monthToUse / (long)this.iMax;
            monthToUse = monthToUse % (long)this.iMax + 1L;
        } else {
            yearToUse = (long)thisYear + monthToUse / (long)this.iMax - 1L;
            int remMonthToUse = (int)((monthToUse = Math.abs(monthToUse)) % (long)this.iMax);
            if (remMonthToUse == 0) {
                remMonthToUse = this.iMax;
            }
            if ((monthToUse = (long)(this.iMax - remMonthToUse + 1)) == 1L) {
                ++yearToUse;
            }
        }
        if (yearToUse < (long)this.iChronology.getMinYear() || yearToUse > (long)this.iChronology.getMaxYear()) {
            throw new IllegalArgumentException("Magnitude of add amount is too large: " + months);
        }
        int i_yearToUse = (int)yearToUse;
        int i_monthToUse = (int)monthToUse;
        int dayToUse = this.iChronology.getDayOfMonth(instant, thisYear, thisMonth);
        if (dayToUse > (maxDay = this.iChronology.getDaysInYearMonth(i_yearToUse, i_monthToUse))) {
            dayToUse = maxDay;
        }
        long datePart = this.iChronology.getYearMonthDayMillis(i_yearToUse, i_monthToUse, dayToUse);
        return datePart + timePart;
    }

    @Override
    public int[] add(ReadablePartial partial, int fieldIndex, int[] values, int valueToAdd) {
        if (valueToAdd == 0) {
            return values;
        }
        if (DateTimeUtils.isContiguous(partial)) {
            long instant = 0L;
            int isize = partial.size();
            for (int i = 0; i < isize; ++i) {
                instant = partial.getFieldType(i).getField(this.iChronology).set(instant, values[i]);
            }
            instant = this.add(instant, valueToAdd);
            return this.iChronology.get(partial, instant);
        }
        return super.add(partial, fieldIndex, values, valueToAdd);
    }

    @Override
    public long addWrapField(long instant, int months) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), months, 1, this.iMax));
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        long subtrahendRem;
        long minuendRem;
        int subtrahendDom;
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifference(subtrahendInstant, minuendInstant);
        }
        int minuendYear = this.iChronology.getYear(minuendInstant);
        int minuendMonth = this.iChronology.getMonthOfYear(minuendInstant, minuendYear);
        int subtrahendYear = this.iChronology.getYear(subtrahendInstant);
        int subtrahendMonth = this.iChronology.getMonthOfYear(subtrahendInstant, subtrahendYear);
        long difference = (long)(minuendYear - subtrahendYear) * (long)this.iMax + (long)minuendMonth - (long)subtrahendMonth;
        int minuendDom = this.iChronology.getDayOfMonth(minuendInstant, minuendYear, minuendMonth);
        if (minuendDom == this.iChronology.getDaysInYearMonth(minuendYear, minuendMonth) && (subtrahendDom = this.iChronology.getDayOfMonth(subtrahendInstant, subtrahendYear, subtrahendMonth)) > minuendDom) {
            subtrahendInstant = this.iChronology.dayOfMonth().set(subtrahendInstant, minuendDom);
        }
        if ((minuendRem = minuendInstant - this.iChronology.getYearMonthMillis(minuendYear, minuendMonth)) < (subtrahendRem = subtrahendInstant - this.iChronology.getYearMonthMillis(subtrahendYear, subtrahendMonth))) {
            --difference;
        }
        return difference;
    }

    @Override
    public long set(long instant, int month) {
        FieldUtils.verifyValueBounds(this, month, 1, this.iMax);
        int thisYear = this.iChronology.getYear(instant);
        int thisDom = this.iChronology.getDayOfMonth(instant, thisYear);
        int maxDom = this.iChronology.getDaysInYearMonth(thisYear, month);
        if (thisDom > maxDom) {
            thisDom = maxDom;
        }
        return this.iChronology.getYearMonthDayMillis(thisYear, month, thisDom) + (long)this.iChronology.getMillisOfDay(instant);
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    @Override
    public boolean isLeap(long instant) {
        int thisYear = this.iChronology.getYear(instant);
        if (this.iChronology.isLeapYear(thisYear)) {
            return this.iChronology.getMonthOfYear(instant, thisYear) == this.iLeapMonth;
        }
        return false;
    }

    @Override
    public int getLeapAmount(long instant) {
        return this.isLeap(instant) ? 1 : 0;
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return this.iMax;
    }

    @Override
    public long roundFloor(long instant) {
        int year = this.iChronology.getYear(instant);
        int month = this.iChronology.getMonthOfYear(instant, year);
        return this.iChronology.getYearMonthMillis(year, month);
    }

    @Override
    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    private Object readResolve() {
        return this.iChronology.monthOfYear();
    }
}

