/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicFixedMonthChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class EthiopicChronology
extends BasicFixedMonthChronology {
    private static final long serialVersionUID = -5972804258688333942L;
    public static final int EE = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("EE");
    private static final int MIN_YEAR = -292269337;
    private static final int MAX_YEAR = 292272984;
    private static final Map cCache = new HashMap();
    private static final EthiopicChronology INSTANCE_UTC = EthiopicChronology.getInstance(DateTimeZone.UTC);

    public static EthiopicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static EthiopicChronology getInstance() {
        return EthiopicChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static EthiopicChronology getInstance(DateTimeZone zone) {
        return EthiopicChronology.getInstance(zone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EthiopicChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        EthiopicChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map map = cCache;
        synchronized (map) {
            EthiopicChronology[] chronos = (EthiopicChronology[])cCache.get(zone);
            if (chronos == null) {
                chronos = new EthiopicChronology[7];
                cCache.put(zone, chronos);
            }
            try {
                chrono = chronos[minDaysInFirstWeek - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
            }
            if (chrono == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new EthiopicChronology(null, null, minDaysInFirstWeek);
                    DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                    chrono = new EthiopicChronology(LimitChronology.getInstance(chrono, lowerLimit, null), null, minDaysInFirstWeek);
                } else {
                    chrono = EthiopicChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                    chrono = new EthiopicChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
                }
                chronos[minDaysInFirstWeek - 1] = chrono;
            }
        }
        return chrono;
    }

    EthiopicChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? EthiopicChronology.getInstance(DateTimeZone.UTC, this.getMinimumDaysInFirstWeek()) : EthiopicChronology.getInstance(base.getZone(), this.getMinimumDaysInFirstWeek());
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return EthiopicChronology.getInstance(zone);
    }

    @Override
    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        int relativeYear = year - 1963;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis + 21859200000L;
    }

    @Override
    int getMinYear() {
        return -292269337;
    }

    @Override
    int getMaxYear() {
        return 292272984;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 30962844000000L;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }
}

