/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.tz.NameProvider;

public class DefaultNameProvider
implements NameProvider {
    private HashMap iByLocaleCache = this.createCache();

    @Override
    public String getShortName(Locale locale, String id, String nameKey) {
        String[] nameSet = this.getNameSet(locale, id, nameKey);
        return nameSet == null ? null : nameSet[0];
    }

    @Override
    public String getName(Locale locale, String id, String nameKey) {
        String[] nameSet = this.getNameSet(locale, id, nameKey);
        return nameSet == null ? null : nameSet[1];
    }

    private synchronized String[] getNameSet(Locale locale, String id, String nameKey) {
        HashMap byNameKeyCache;
        if (locale == null || id == null || nameKey == null) {
            return null;
        }
        HashMap byIdCache = (HashMap)this.iByLocaleCache.get(locale);
        if (byIdCache == null) {
            byIdCache = this.createCache();
            this.iByLocaleCache.put(locale, byIdCache);
        }
        if ((byNameKeyCache = (HashMap)byIdCache.get(id)) == null) {
            byNameKeyCache = this.createCache();
            byIdCache.put(id, byNameKeyCache);
            String[][] zoneStrings = new DateFormatSymbols(locale).getZoneStrings();
            for (int i = 0; i < zoneStrings.length; ++i) {
                String[] set = zoneStrings[i];
                if (set == null || set.length != 5 || !id.equals(set[0])) continue;
                byNameKeyCache.put(set[2], new String[]{set[2], set[1]});
                if (set[2].equals(set[4])) {
                    byNameKeyCache.put(set[4] + "-Summer", new String[]{set[4], set[3]});
                    break;
                }
                byNameKeyCache.put(set[4], new String[]{set[4], set[3]});
                break;
            }
        }
        return (String[])byNameKeyCache.get(nameKey);
    }

    private HashMap createCache() {
        return new HashMap(7);
    }
}

