/*
 * Decompiled with CFR 0.152.
 */
package processingError;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import processingError.ErrorProcessor;
import processingError.Location;
import processingError.ProcessingError;
import processingError.SimpleLocation;

public abstract class AbstractProcessingError
implements ProcessingError {
    private static final Location NULL_LOCATION = new SimpleLocation(0, 0, "", null);
    private Location location = NULL_LOCATION;
    private ErrorProcessor errorProcessor;
    private ProcessingError chainedError = null;
    private final List<Object> applicationData = new ArrayList<Object>();

    public AbstractProcessingError(Location location) {
        this.location = location;
    }

    public AbstractProcessingError(Location location, Attributes attributes) {
        this(location);
    }

    public String toString() {
        String lookupString = "";
        if (this.getLocation() != null) {
            lookupString = ":" + this.getLocation().getLineNumber() + ":" + this.getLocation().getColumnNumber() + ":" + this.buildTagName() + ":";
        }
        String result = lookupString = lookupString + this.getDescription();
        if (this.getValueInError() != null) {
            result = result + ":[" + this.getValueInError() + "]";
        }
        return result;
    }

    protected String buildTagName() {
        String result = this.getLocation().getTagName();
        Attributes attributes = this.getLocation().getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            result = result + "[";
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + attributes.getQName(i) + "='";
                result = result + attributes.getValue(i) + "'";
            }
            result = result + "]";
        }
        return result;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public List<Object> getApplicationData() {
        return this.applicationData;
    }

    public void addApplicationData(Object datum) {
        this.applicationData.add(datum);
    }

    @Override
    public String getDescription() {
        return this.getRuleName() + "." + this.getSubCode();
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public ErrorProcessor getErrorProcessor() {
        return this.errorProcessor;
    }

    public void setErrorProcessor(ErrorProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
    }

    @Override
    public ProcessingError getChainedError() {
        return this.chainedError;
    }

    public void setChainedError(ProcessingError chainedError) {
        this.chainedError = chainedError;
    }

    @Override
    public String getErrorCode() {
        return null;
    }

    @Override
    public String getMessage() {
        return null;
    }
}

