/*
 * Decompiled with CFR 0.152.
 */
package processingError;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import processingError.ErrorLimitExceeded;
import processingError.ProcessingError;
import processingError.ProcessingErrorCollector;

public class SimpleErrorCollector
implements ProcessingErrorCollector {
    private final List<ProcessingError> errors = new ArrayList<ProcessingError>();
    private Object errorExtraInfo = null;
    private int maxErrors = 100000;

    @Override
    public void addError(ProcessingError error) {
        if (this.maxErrors > 0 && this.errors.size() >= this.maxErrors) {
            throw new ErrorLimitExceeded(this.maxErrors, error);
        }
        this.errors.add(error);
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    @Override
    public List<ProcessingError> getErrors() {
        return this.errors;
    }

    @Override
    public Object getErrorExtraInfo() {
        return this.errorExtraInfo;
    }

    @Override
    public void setErrorExtraInfo(Object errorExtraInfo) {
        this.errorExtraInfo = errorExtraInfo;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Override
    public void dumpErrorsNotOfType(Class<? extends ProcessingError> clazz) {
        Iterator<ProcessingError> iter = this.errors.iterator();
        while (iter.hasNext()) {
            ProcessingError error = iter.next();
            if (clazz.isAssignableFrom(error.getClass())) continue;
            iter.remove();
        }
    }
}

