/*
 * Decompiled with CFR 0.152.
 */
package validationResponse.output;

import com.gsl.util.ComparatorMap;
import com.gsl.util.HashCode;
import com.gsl.util.ObjectUtil;
import com.gsl.util.ReversibleComparator;
import java.util.Comparator;
import java.util.Date;
import validationResponse.output.FullNameComparator;
import validationResponse.output.LastModifiedComparator;

public class ArtefactVersionDescriptor {
    public static final int FULL_NAME_ID = 0;
    public static final int LAST_MODIFIED_ID = 1;
    private static ComparatorMap<ArtefactVersionDescriptor> COMPARATOR_MAP = new ComparatorMap();
    private final String fullName;
    private final Date lastModified;
    private final int hashCode;

    public static Comparator<ArtefactVersionDescriptor> getComparator(int id, int direction) {
        ReversibleComparator<ArtefactVersionDescriptor> comparator = COMPARATOR_MAP.get(id, direction);
        if (comparator == null) {
            switch (id) {
                default: {
                    comparator = new FullNameComparator(direction);
                    break;
                }
                case 1: {
                    comparator = new LastModifiedComparator(direction);
                }
            }
            COMPARATOR_MAP.add(id, direction, comparator);
        }
        return comparator;
    }

    public ArtefactVersionDescriptor(String fullName, Date lastModified) {
        this.fullName = fullName;
        this.lastModified = lastModified;
        this.hashCode = this.calculateHashCode();
    }

    public Date getLastModifiedDate() {
        return this.lastModified;
    }

    public String getFullName() {
        return this.fullName;
    }

    private int calculateHashCode() {
        int result = 23;
        result = HashCode.hash(result, this.fullName);
        result = HashCode.hash(result, this.lastModified);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ArtefactVersionDescriptor other = (ArtefactVersionDescriptor)o;
        return this.fullName.equals(other.fullName) && ObjectUtil.nullSafeEquals(this.lastModified, other.lastModified);
    }
}

