/*
 * Decompiled with CFR 0.152.
 */
package validationResponse.output;

import bizrules.BusinessRuleError;
import com.gsl.sax.xerces.XercesParserMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import processingError.ProcessingError;
import xmldoc.DocumentErrorBean;
import xmldoc.ParserParams;

public class ErrorResponseLoader
extends DefaultHandler {
    private List<ProcessingError> errorList = new ArrayList<ProcessingError>();
    private ErrorData currentErrorData = null;
    private ActiveElement currentlyCollecting = ActiveElement.None;

    public ErrorResponseLoader(InputStream errorResponseDocumentStream) throws SAXException, IOException {
        XMLReader sp = this.getParser();
        InputSource isrc = new InputSource(errorResponseDocumentStream);
        sp.parse(isrc);
    }

    public ErrorResponseLoader(Reader errorResponseDocumentStream) throws SAXException, IOException {
        XMLReader sp = this.getParser();
        InputSource isrc = new InputSource(errorResponseDocumentStream);
        sp.parse(isrc);
    }

    public List<ProcessingError> getErrorList() {
        return this.errorList;
    }

    private XMLReader getParser() throws SAXException {
        ParserParams parserParams = new ParserParams();
        XMLReader parser = XercesParserMaker.makeParser(parserParams);
        parser.setErrorHandler(this);
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("Error")) {
            this.currentErrorData = new ErrorData();
        } else {
            try {
                this.currentlyCollecting = ActiveElement.valueOf(localName);
            }
            catch (IllegalArgumentException e) {
                this.currentlyCollecting = ActiveElement.None;
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal error: e.getMessage()");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer data = new StringBuffer();
        data.append(ch, start, length);
        switch (this.currentlyCollecting) {
            case Number: {
                this.currentErrorData.number = this.currentErrorData.number + data.toString();
                break;
            }
            case Type: {
                this.currentErrorData.type = this.currentErrorData.type + data.toString();
                break;
            }
            case Text: {
                this.currentErrorData.text = this.currentErrorData.text + data.toString();
                break;
            }
            case Location: {
                this.currentErrorData.location = this.currentErrorData.location + data.toString();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName.equals("Error")) {
            ProcessingError error = this.makeError(this.currentErrorData);
            if (error != null) {
                this.errorList.add(error);
            }
            this.currentErrorData = null;
        }
        this.currentlyCollecting = ActiveElement.None;
    }

    private ProcessingError makeError(ErrorData currentErrorData2) {
        ProcessingError result = null;
        if (this.currentErrorData.type.equals("business")) {
            BusinessRuleError be = new BusinessRuleError(null, this.currentErrorData.number);
            be.setErrorCode(this.currentErrorData.number);
            be.setXPathLocation(this.currentErrorData.location);
            be.setMessage(this.currentErrorData.text);
            result = be;
        } else if (this.currentErrorData.type.equals("schema")) {
            DocumentErrorBean de = new DocumentErrorBean(null);
            de.setXPathLocation(this.currentErrorData.location);
            de.setSAXErrorMessage(this.currentErrorData.text);
            de.setSubCode(this.currentErrorData.number);
            result = de;
        }
        return result;
    }

    static enum ActiveElement {
        None,
        Number,
        Type,
        Text,
        Location;

    }

    private class ErrorData {
        String number = "";
        String type = "";
        String text = "";
        String location = "";

        private ErrorData() {
        }
    }
}

