/*
 * Decompiled with CFR 0.152.
 */
package validationResponse.output;

import com.gsl.docValidator.PostValidationDelegate;
import com.gsl.docValidator.ValidationParams;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import processingError.ProcessingError;
import validationResponse.output.AudienceMessage;
import validationResponse.output.JDomOutputterUtil;
import validationResponse.output.ProcessingErrorMapper;
import validationResponse.output.UserLocatorMessage;
import validationResponse.output.ValidationResultBean;
import validationResponse.output.ValidationResultInterface;
import validationResponse.output.XercesErrorMapper;
import xmldoc.DocumentError;

public class ValidationResponseDelegate
implements PostValidationDelegate {
    private final OutputStream output;
    private static final Namespace NS_XSI = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/001/XMLSchema-instance");
    private static final Namespace NS_VALIDATION_RESPONSE = Namespace.getNamespace((String)"val", (String)"http://www.hmrc.gov.uk/internal/validation/1");
    private static final Namespace NS_ERROR_RESPONSE = Namespace.getNamespace((String)"err", (String)"http://www.govtalk.gov.uk/CM/errorresponse");
    private static final Namespace NS_RIM = Namespace.getNamespace((String)"rim", (String)"http://www.govtalk.gov.uk/taxation/common/validation-MIS/1");
    private ProcessingErrorMapper errorMapper;

    public ValidationResponseDelegate(ValidationParams responseParams, OutputStream output) {
        this.output = output;
        this.errorMapper = new XercesErrorMapper(responseParams);
    }

    @Override
    public ValidationResultInterface createResult(List<ProcessingError> processingErrors, ValidationParams params) {
        ValidationResultBean result = this.createResultBean();
        if (this.output != null) {
            Attribute schemaLocation = new Attribute("schemaLocation", "www://www.hmrc.gov.uk/internal/validation/1 validationResponse.xsd");
            schemaLocation.setNamespace(NS_XSI);
            Element validationResponse = new Element("ValidationResponse", NS_VALIDATION_RESPONSE);
            validationResponse.setAttribute(schemaLocation);
            if (processingErrors.size() > 0) {
                Element errorResponseElement = new Element("ErrorResponse", NS_ERROR_RESPONSE);
                errorResponseElement.setAttribute("SchemaVersion", "2.0");
                validationResponse.addContent((Content)errorResponseElement);
                for (int i = 0; i < processingErrors.size(); ++i) {
                    ProcessingError error = processingErrors.get(i);
                    ProcessingError mappedError = this.getErrorMapper().mapError(error);
                    if (mappedError != error) {
                        processingErrors.set(i, mappedError);
                    }
                    errorResponseElement.addContent((Content)this.makeErrorElement(mappedError));
                }
            }
            Element misElement = new Element("MIS", NS_VALIDATION_RESPONSE);
            Element errorCount = new Element("ErrorCount", NS_RIM);
            errorCount.setText("" + processingErrors.size());
            misElement.addContent((Content)errorCount);
            validationResponse.addContent((Content)misElement);
            Document doc = new Document();
            doc.setRootElement(validationResponse);
            JDomOutputterUtil.writeToOutput(this.output, doc);
        }
        return result;
    }

    private Element makeErrorElement(ProcessingError error) {
        List<?> applicationData;
        Element errorElement = new Element("Error", NS_ERROR_RESPONSE);
        errorElement.addContent((Content)this.makeLeaf("RaisedBy", NS_ERROR_RESPONSE, "ChRIS"));
        errorElement.addContent((Content)this.makeLeaf("Number", NS_ERROR_RESPONSE, error.getErrorCode()));
        if (error instanceof DocumentError) {
            errorElement.addContent((Content)this.makeLeaf("Type", NS_ERROR_RESPONSE, "schema"));
        } else {
            errorElement.addContent((Content)this.makeLeaf("Type", NS_ERROR_RESPONSE, "business"));
        }
        errorElement.addContent((Content)this.makeLeaf("Text", NS_ERROR_RESPONSE, error.getMessage()));
        errorElement.addContent((Content)this.makeLeaf("Location", NS_ERROR_RESPONSE, error.getXPathLocation()));
        if (error.getValueInError() != null) {
            errorElement.addContent((Content)this.makeLeaf("ErrorData", NS_ERROR_RESPONSE, error.getValueInError().toString()));
        }
        if ((applicationData = error.getApplicationData()).size() > 0) {
            Element applicationElement = new Element("Application", NS_ERROR_RESPONSE);
            errorElement.addContent((Content)applicationElement);
            Element audienceMessages = null;
            for (Object datum : applicationData) {
                if (!(datum instanceof AudienceMessage)) continue;
                if (audienceMessages == null) {
                    audienceMessages = new Element("Messages", NS_VALIDATION_RESPONSE);
                }
                audienceMessages.addContent((Content)this.makeAudienceMessage((AudienceMessage)datum));
            }
            if (audienceMessages != null) {
                applicationElement.addContent(audienceMessages);
            }
        }
        return errorElement;
    }

    private Element makeAudienceMessage(AudienceMessage am) {
        String type = am.getType();
        if ("developer".equals(type)) {
            type = "DeveloperMessage";
        } else if ("service".equals(type)) {
            type = "ServiceMessage";
        }
        Element message = new Element(type, NS_VALIDATION_RESPONSE);
        if (am instanceof UserLocatorMessage) {
            Element userLocator = new Element("UserLocation", NS_VALIDATION_RESPONSE);
            userLocator.setText(am.getMessage());
            message.addContent((Content)userLocator);
        } else {
            message.setText(am.getMessage());
        }
        return message;
    }

    private Element makeLeaf(String elementName, Namespace namespace, String text) {
        Element element = new Element(elementName, namespace);
        element.setText(text);
        return element;
    }

    public ProcessingErrorMapper getErrorMapper() {
        return this.errorMapper;
    }

    public void setErrorMapper(ProcessingErrorMapper errorMapper) {
        this.errorMapper = errorMapper;
    }

    protected ValidationResultBean createResultBean() {
        return new ValidationResultBean();
    }
}

