/*
 * Decompiled with CFR 0.152.
 */
package validationResponse.output;

import com.gsl.docValidator.ValidationParams;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processingError.ProcessingError;
import validationResponse.output.AudienceMessage;
import validationResponse.output.ErrorPatternMatch;
import validationResponse.output.ProcessingErrorMapper;
import xmldoc.DocumentError;
import xmldoc.DocumentErrorBean;

public class XercesErrorMapper
implements ProcessingErrorMapper {
    private static String[][] simpleMappingTable = new String[0][];
    private static String[][] patternMatchingTable = new String[][]{{"cvc-attribute.[34]: The value '(.*)' of attribute.*", "4000", "Invalid attribute value - '%1$s'", "%1$s"}, {"cvc-complex-type.2.1: Element '(.*)' must.*", "4051", "Element '%1$s' must have no children"}, {"cvc-complex-type.2.2: Element '(.*)' must.*", "4052", "Element '%1$s' must only have valid text as its content"}, {"cvc-complex-type.2.3: Element '(.*)' cannot.*", "4053", "Element '%1$s' must only have elements as its content"}, {"cvc-complex-type.2.4.a: .*element '(.*)'\\. One of.*", "4065", "Invalid content found at element '%1$s'"}, {"cvc-complex-type.2.4.b: .*element '(.*)' is not complete.*", "4066", "Incomplete content found at element '%1$s'"}, {"cvc-complex-type.2.4.c: .*element '(.*)'\\.", "4067", "Element '%1$s' is missing"}, {"cvc-complex-type.2.4.d: .*element '(.*)'\\. No child.*", "4051", "Invalid content found at element '%1$s'"}, {"cvc-complex-type.3.1: .*element '(.*)' is not valid.*", "4000", "Invalid attribute value - '%1$s'"}, {"cvc-complex-type.3.2.1: Element '(.*)' does not.*", "4000", "Invalid attribute value - '%1$s'"}, {"cvc-complex-type.3.2.2: .*in element '(.*)'\\.", "4000", "Invalid attribute value - '%1$s'"}, {"cvc-complex-type.4: .*element '(.*)'\\.", "4001", "Missing attribute on element '%1$s'"}, {"cvc-complex-type.5.1: .*In element '(.*)',.*", "4002", "Invalid attribute specified on element '%1$s'"}, {"cvc-complex-type.5.2: .*In element '(.*)',.*", "4002", "Invalid attribute specified on element '%1$s'"}, {"cvc-datatype-valid.1.2.[123]: '(.*)' is not.*", "4020", "Invalid value '%1$s'", "%1$s"}, {"cvc-elt.1: .*element '(.*)'\\.", "4057", "Invalid element '%1$s'"}, {"cvc-elt.3.1: .*element '(.*)', because.*", "4003", "Invalid attribute '%1$s' on element"}, {"cvc-elt-3.2.1: Element '(.*)' cannot.*", "4051", "Element '%1$s' must have no children"}, {"cvc-elt.4.1: .*element '(.*)' is not.*", "4000", "Invalid attribute value - '%1$s'"}, {"cvc-elt.4.2: .*Element '(.*)' must.*", "4050", "Invalid element value - '%1$s'"}, {"cvc-elt.5.2.2.1: Element '(.*)' must.*", "4051", "Element '%1$s' must have no children"}, {"cvc-elt.5.2.2.2.1: The value '(.*)' of element.*", "4058", "Value '%1$s' doesn't match the expected value as set in the schema", "%1$s", "%1$s"}, {"cvc-elt.5.2.2.2.2: The value '(.*)' of element.*", "4058", "Value '%1$s' doesn't match the expected value as set in the schema", "%1$s", "%1$s"}, {"cvc-enumeration-valid: Value '(.*)' is not.*", "4080", "Value '%1$s' is not one of the allowed enumerated values", "%1$s"}, {"cvc-fractionDigits-valid: Value '(.*)' has.*", "4081", "Value '%1$s' has too many fraction digits", "%1$s"}, {"cvc-length-valid: Value '(.*)' with.*", "4082", "Value '%1$s' has an incorrect length", "%1$s"}, {"cvc-maxExclusive-valid: Value '(.*)' is.*", "4083", "Value '%1$s' is too large", "%1$s"}, {"cvc-maxInclusive-valid: Value '(.*)' is.*", "4083", "Value '%1$s' is too large", "%1$s"}, {"cvc-maxLength-valid: Value '(.*)' with.*", "4083", "Value '%1$s' is too large", "%1$s"}, {"cvc-minExclusive-valid: Value '(.*)' is not.*", "4084", "Value '%1$s' is too small", "%1$s"}, {"cvc-minInclusive-valid: Value '(.*)' is not.*", "4084", "Value '%1$s' is too small", "%1$s"}, {"cvc-minLength-valid: Value '(.*)' with.*", "4082", "Value '%1$s' has an incorrect length", "%1$s"}, {"cvc-pattern-valid: Value '(.*)' is not.*", "4085", "Value '%1$s' doesn't have the correct format", "%1$s"}, {"cvc-totalDigits-valid: Value '(.*)' has.*", "4085", "Value '%1$s' has too many digits", "%1$s"}, {"cvc-type.3.1.1: Element '(.*)' is a simple type.*", "4068", "Element '%1$s' cannot have attributes"}, {"cvc-type.3.1.2: Element '(.*)' is a simple type.*", "4051", "Element '%1$s' must have no children"}, {"cvc-type.3.1.3: The value '(.*)' of element '(.*)' is not valid\\.", "4065", "Invalid content found at element '%2$s'", "%1$s"}};
    private final ValidationParams responseParams;

    public XercesErrorMapper(ValidationParams responseParams) {
        this.responseParams = responseParams;
    }

    @Override
    public ProcessingError mapError(ProcessingError error) {
        ProcessingError result = error;
        if (error instanceof DocumentError) {
            DocumentErrorBean newError = null;
            newError = this.tryPatternMatch(error);
            if (newError == null) {
                newError = this.trySimpleMatch(error);
            }
            if (newError == null) {
                newError = this.createCatchAllError(error);
            }
            if (newError != null) {
                result = newError;
            }
        }
        return result;
    }

    private DocumentErrorBean tryPatternMatch(ProcessingError originalError) {
        DocumentErrorBean newError = null;
        ErrorPatternMatch match = this.matchErrorMessage(originalError.getMessage());
        if (match != null) {
            newError = new DocumentErrorBean(originalError.getLocation());
            newError.setXPathLocation(originalError.getXPathLocation());
            newError.setChainedError(originalError);
            newError.setSubCode(match.getErrorCode());
            newError.setSAXErrorMessage(match.getMessage());
            newError.setValueInError(match.getValueInError());
            if (this.responseParams.getOutputDeveloperMessages()) {
                AudienceMessage am = new AudienceMessage("developer", originalError.getMessage());
                newError.addApplicationData(am);
            }
        }
        return newError;
    }

    private DocumentErrorBean trySimpleMatch(ProcessingError originalError) {
        DocumentErrorBean newError = null;
        for (String[] element : simpleMappingTable) {
            if (!originalError.getMessage().startsWith(element[0])) continue;
            newError = new DocumentErrorBean(originalError.getLocation());
            newError.setXPathLocation(originalError.getXPathLocation());
            newError.setChainedError(originalError);
            newError.setSubCode(simpleMappingTable[0][1]);
            newError.setSAXErrorMessage(simpleMappingTable[0][2]);
            if (!this.responseParams.getOutputDeveloperMessages()) break;
            AudienceMessage am = new AudienceMessage("developer", originalError.getMessage());
            newError.addApplicationData(am);
            break;
        }
        return newError;
    }

    public ErrorPatternMatch matchErrorMessage(String message) {
        ErrorPatternMatch result = null;
        boolean matched = false;
        for (int i = 0; i < patternMatchingTable.length && !matched; ++i) {
            String[] tableEntry = patternMatchingTable[i];
            Pattern pattern = Pattern.compile(tableEntry[0], 32);
            Matcher matcher = pattern.matcher(message);
            matched = matcher.matches();
            if (!matched) continue;
            String messageTemplate = tableEntry[2];
            String errorCode = tableEntry[1];
            String valueInErrorTemplate = null;
            if (tableEntry.length > 3) {
                valueInErrorTemplate = tableEntry[3];
            }
            result = new ErrorPatternMatch(matcher, messageTemplate, errorCode, valueInErrorTemplate);
        }
        return result;
    }

    private DocumentErrorBean createCatchAllError(ProcessingError error) {
        DocumentErrorBean newError = new DocumentErrorBean(error.getLocation());
        newError.setXPathLocation(error.getXPathLocation());
        newError.setChainedError(error);
        newError.setSubCode("4999");
        newError.setSAXErrorMessage("Internal schema validation error");
        if (this.responseParams.getOutputDeveloperMessages()) {
            AudienceMessage am = new AudienceMessage("developer", error.getMessage());
            newError.addApplicationData(am);
        }
        return newError;
    }
}

