/*
 * Decompiled with CFR 0.152.
 */
package xmldoc;

import java.util.HashSet;
import java.util.Set;
import processingError.AbstractProcessingError;
import processingError.Location;
import xmldoc.DocumentError;
import xmldoc.ElementReference;

public class DocumentErrorBean
extends AbstractProcessingError
implements DocumentError {
    private static Set<String> subCodeSet;
    private ElementReference elementReference;
    private Object underlyingError;
    private String subCode = "unknown";
    private Object extraInfo = null;
    private Object valueInError;
    private String saxErrorMessage = "";
    private String xPathLocation = null;
    private String attributeName = null;

    public DocumentErrorBean(Location location) {
        super(location);
    }

    @Override
    public String getXPathLocation() {
        if (this.xPathLocation != null && this.attributeName != null) {
            return this.xPathLocation + "/@" + this.attributeName;
        }
        return this.xPathLocation;
    }

    @Override
    public void setXPathLocation(String pathLocation) {
        this.xPathLocation = pathLocation;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            DocumentErrorBean that = (DocumentErrorBean)other;
            if (this.elementReference == null && that.elementReference == null && this.subCode.equals(that.subCode) && this.extraInfo == null && that.extraInfo == null) {
                result = true;
            } else {
                boolean bl = result = this.elementReference != null && this.elementReference.equals(that.elementReference) && this.subCode != null && this.subCode.equals(that.subCode);
                if (result) {
                    if (this.extraInfo != null) {
                        result = this.extraInfo.equals(that.extraInfo);
                    } else if (that.extraInfo != null) {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public int hashCode() {
        return ("" + this.elementReference + this.subCode + this.extraInfo).hashCode();
    }

    @Override
    public ElementReference getElementReference() {
        return this.elementReference;
    }

    @Override
    public Object getOriginalError() {
        return this.underlyingError;
    }

    @Override
    public void setElementReference(ElementReference elementReference) {
        this.elementReference = elementReference;
    }

    public void setUnderlyingError(Object underlyingError) {
        this.underlyingError = underlyingError;
    }

    @Override
    public void setSubCode(String errorCode) {
        this.subCode = errorCode;
    }

    @Override
    public String getErrorCode() {
        return this.getSubCode();
    }

    @Override
    public Object getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public void setExtraInfo(Object extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public String getRuleName() {
        return this.buildTagName();
    }

    @Override
    public Object getValueInError() {
        return this.valueInError;
    }

    public void setValueInError(Object valueInError) {
        this.valueInError = valueInError;
    }

    @Override
    public String toString() {
        String str = "DocumentError:" + super.toString();
        String message = this.getSAXErrorMessage();
        if (message != null) {
            str = str + " (" + message + ")";
        }
        return str;
    }

    @Override
    public String getSubCode() {
        return this.subCode;
    }

    public String getSAXErrorMessage() {
        return this.saxErrorMessage;
    }

    @Override
    public String getMessage() {
        return this.getSAXErrorMessage();
    }

    @Override
    public void setSAXErrorMessage(String message) {
        this.saxErrorMessage = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getDocumentErrorSubCodes() {
        if (subCodeSet != null) return subCodeSet;
        Class<DocumentErrorBean> clazz = DocumentErrorBean.class;
        synchronized (DocumentErrorBean.class) {
            if (subCodeSet != null) return subCodeSet;
            HashSet<String> newSubCodeSet = new HashSet<String>();
            newSubCodeSet.add("attribute");
            newSubCodeSet.add("blank");
            newSubCodeSet.add("format");
            newSubCodeSet.add("invalid");
            newSubCodeSet.add("mandatory");
            newSubCodeSet.add("maxvalue");
            newSubCodeSet.add("minvalue");
            newSubCodeSet.add("value");
            subCodeSet = newSubCodeSet;
            // ** MonitorExit[var0] (shouldn't be in output)
            return subCodeSet;
        }
    }

    public static boolean isDocumentErrorCode(String subCode) {
        return DocumentErrorBean.getDocumentErrorSubCodes().contains(subCode);
    }
}

