/*
 * Decompiled with CFR 0.152.
 */
package xmldoc;

import java.util.HashMap;
import java.util.Map;

public final class DocumentEventType {
    private static final String START_ELEMENT_STRING = "startElement";
    private static final String END_ELEMENT_STRING = "endElement";
    private static final String ELEMENT_TEXT_STRING = "elementText";
    private static final String END_DOCUMENT_STRING = "endDocument";
    private static final String START_DOCUMENT_STRING = "startDocument";
    private static final String DOCUMENT_ERROR_STRING = "documentError";
    public static final DocumentEventType startElement = new DocumentEventType("startElement");
    public static final DocumentEventType endElement = new DocumentEventType("endElement");
    public static final DocumentEventType elementText = new DocumentEventType("elementText");
    public static final DocumentEventType startDocument = new DocumentEventType("startDocument");
    public static final DocumentEventType endDocument = new DocumentEventType("endDocument");
    public static final DocumentEventType documentError = new DocumentEventType("documentError");
    private final String typeString;
    private static final Map<String, DocumentEventType> typeMap = new HashMap<String, DocumentEventType>();

    private DocumentEventType(String typeString) {
        this.typeString = typeString;
    }

    public String toString() {
        return this.typeString;
    }

    public static DocumentEventType fromString(String typeString) {
        DocumentEventType type = typeMap.get(typeString);
        if (type == null) {
            throw new IllegalArgumentException("Document event type '" + typeString + "' not supported");
        }
        return type;
    }

    static {
        typeMap.put(startElement.toString(), startElement);
        typeMap.put(endElement.toString(), endElement);
        typeMap.put(elementText.toString(), startElement);
        typeMap.put(startDocument.toString(), startDocument);
        typeMap.put(endDocument.toString(), endDocument);
    }
}

