/*
 * Decompiled with CFR 0.152.
 */
package xmldoc;

import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import processingError.Location;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class DocumentLocation
implements Location {
    private final int lineNumber;
    private final int columnNumber;
    private ElementReference elementRef;
    private final Attributes attributes;

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public DocumentLocation(int lineNumber, int columnNumber, ElementReference ref, Attributes attributes) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.elementRef = ref != null ? ref : SimpleElementReference.makeReference("", "");
        this.attributes = attributes;
    }

    public DocumentLocation(int lineNumber, int columnNumber, String tagName, Attributes attributes) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.elementRef = SimpleElementReference.makeReference("", tagName);
        this.attributes = attributes;
    }

    public DocumentLocation(int lineNumber, int columnNumber, String tagName) {
        this(lineNumber, columnNumber, tagName, null);
    }

    public DocumentLocation(SAXParseException ex, ElementReference elementRef) {
        this(ex.getLineNumber(), ex.getColumnNumber(), elementRef, null);
    }

    @Override
    public String getTagName() {
        return this.elementRef.getXPath();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

