/*
 * Decompiled with CFR 0.152.
 */
package xmldoc;

import com.gsl.util.collections.NestedHashMapTwoKeyMap;
import com.gsl.util.collections.TwoKeyMap;
import xmldoc.ElementReference;

public class SimpleElementReference
implements ElementReference {
    private static final long serialVersionUID = -6477236450321651159L;
    private static final TwoKeyMap<String, String, ElementReference> referenceCache = new NestedHashMapTwoKeyMap<String, String, ElementReference>();
    private final String xPath;
    private final String namespaceURL;

    public static ElementReference makeReference(String xPath) {
        return SimpleElementReference.makeReference(null, xPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElementReference makeReference(String namespaceURL, String xPath) {
        ElementReference ref = referenceCache.get(namespaceURL, xPath);
        if (ref == null) {
            TwoKeyMap<String, String, ElementReference> twoKeyMap = referenceCache;
            synchronized (twoKeyMap) {
                ref = referenceCache.get(namespaceURL, xPath);
                if (ref == null) {
                    ref = new SimpleElementReference(namespaceURL, xPath);
                    referenceCache.put(namespaceURL, xPath, ref);
                }
            }
        }
        return ref;
    }

    private SimpleElementReference(String namespaceurl, String path) {
        this.namespaceURL = namespaceurl;
        this.xPath = path;
    }

    @Override
    public String getNamespaceURL() {
        return this.namespaceURL;
    }

    @Override
    public String getXPath() {
        return this.xPath;
    }

    public String toString() {
        return "SimpleElementReference [xpath='" + this.xPath + "', namespace='" + this.namespaceURL + "']";
    }
}

