/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.sax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import processingError.ErrorLimitExceeded;
import processingError.ProcessingErrorCollector;
import processingError.SimpleErrorCollector;
import xmldoc.Attribute;
import xmldoc.AttributeDetail;
import xmldoc.DocumentError;
import xmldoc.DocumentEventReceiver;
import xmldoc.DocumentLocation;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import xmldoc.sax.DocumentErrorFilter;
import xmldoc.sax.DocumentHandler;
import xmldoc.sax.NullSAXExceptionDecoder;
import xmldoc.sax.SAXExceptionDecoder;
import xmldoc.sax.TerminateParse;

public abstract class AbstractDocumentHandler
extends DefaultHandler
implements DocumentHandler {
    protected final DocumentEventReceiver docEventReceiver;
    protected ProcessingErrorCollector errorCollector;
    protected EntityResolver entityResolver;
    protected SAXExceptionDecoder exceptionDecoder = new NullSAXExceptionDecoder();
    protected ElementReference currentElementRef = SimpleElementReference.makeReference("", "");
    private boolean dumpBusinessErrorsOnDocumentError = false;
    private final List<DocumentErrorFilter> documentErrorFilters = new ArrayList<DocumentErrorFilter>();
    private boolean interrupted = false;

    public AbstractDocumentHandler(DocumentEventReceiver docEventReceiver) {
        this.docEventReceiver = docEventReceiver;
    }

    public DocumentEventReceiver getDocEventReceiver() {
        return this.docEventReceiver;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    protected final void checkTerminated() {
        if (this.interrupted) {
            throw new TerminateParse();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.checkTerminated();
        this.getErrorCollector();
        this.docEventReceiver.startDocument();
    }

    protected Attribute[] createAttributeArray(Attributes attributes) {
        Attribute[] attrs = new Attribute[attributes.getLength()];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = new AttributeDetail(attributes.getLocalName(i), attributes.getValue(i));
        }
        return attrs;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.checkTerminated();
        this.docEventReceiver.elementText(this.currentElementRef, ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.checkTerminated();
        this.docEventReceiver.endDocument();
    }

    protected DocumentError createDocumentError(SAXParseException ex) {
        DocumentError error = this.exceptionDecoder.decodeException(this.currentElementRef, ex);
        error.setLocation(new DocumentLocation(ex, error.getElementReference()));
        Object extraInfo = this.getErrorCollector().getErrorExtraInfo();
        error.setExtraInfo(extraInfo);
        return error;
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        DocumentError error = this.createDocumentError(ex);
        boolean shouldCollectError = true;
        for (DocumentErrorFilter filter : this.documentErrorFilters) {
            if (filter.collectError(error)) continue;
            shouldCollectError = false;
            break;
        }
        if (shouldCollectError) {
            this.collectError(error);
        }
    }

    private void collectError(DocumentError error) throws ErrorLimitExceeded {
        if (!this.getDocEventReceiver().handleError(error) && !error.getSubCode().equals("suppress")) {
            if (this.getDumpBusinessErrorsOnDocumentError() && !this.getErrorCollector().getErrors().isEmpty()) {
                this.getErrorCollector().dumpErrorsNotOfType(DocumentError.class);
            }
            this.getErrorCollector().addError(error);
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.error(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        DocumentError error = this.createDocumentError(ex);
        this.collectError(error);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource result = null;
        try {
            if (this.entityResolver != null) {
                result = this.entityResolver.resolveEntity(publicId, systemId);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return result;
    }

    public ProcessingErrorCollector getErrorCollector() {
        if (this.errorCollector == null) {
            this.errorCollector = new SimpleErrorCollector();
        }
        return this.errorCollector;
    }

    @Override
    public void setErrorCollector(ProcessingErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void setExceptionDecoder(SAXExceptionDecoder exceptionDecoder) {
        this.exceptionDecoder = exceptionDecoder;
    }

    public boolean getDumpBusinessErrorsOnDocumentError() {
        return this.dumpBusinessErrorsOnDocumentError;
    }

    @Override
    public void setDumpBusinessErrorsOnDocumentError(boolean dumpBusinessErrorsOnDocumentError) {
        this.dumpBusinessErrorsOnDocumentError = dumpBusinessErrorsOnDocumentError;
    }

    @Override
    public void addDocumentErrorFilter(DocumentErrorFilter filter) {
        this.documentErrorFilters.add(filter);
    }
}

