/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.sax;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import xmldoc.Attribute;
import xmldoc.DocumentEventReceiver;
import xmldoc.NamespacePrefixMapper;
import xmldoc.SimpleElementReference;
import xmldoc.sax.AbstractDocumentHandler;

public class DocumentHandlerImpl
extends AbstractDocumentHandler {
    private final Map<String, Stack<String>> currentElementStacks = new HashMap<String, Stack<String>>();

    public DocumentHandlerImpl(DocumentEventReceiver docEventReceiver) {
        super(docEventReceiver);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.checkTerminated();
        String currentElement = this.getCurrentElement(namespaceURI);
        if ("".equals(currentElement)) {
            this.docEventReceiver.startNamespace(namespaceURI);
        }
        this.getCurrentElementStack(namespaceURI).push(currentElement + "/" + localName);
        currentElement = this.getCurrentElement(namespaceURI);
        this.currentElementRef = SimpleElementReference.makeReference(namespaceURI, currentElement);
        Attribute[] attrs = this.createAttributeArray(attributes);
        this.docEventReceiver.startElement(this.currentElementRef, attrs);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkTerminated();
        this.docEventReceiver.endElement(this.currentElementRef);
        this.getCurrentElementStack(namespaceURI).pop();
        String currentElement = this.getCurrentElement(namespaceURI);
        if ("".equals(currentElement)) {
            this.docEventReceiver.endNamespace(namespaceURI);
        }
        this.currentElementRef = SimpleElementReference.makeReference(namespaceURI, currentElement);
    }

    private String getCurrentElement(String namespaceURI) {
        String result = "";
        Stack<String> stack = this.getCurrentElementStack(namespaceURI);
        if (!stack.isEmpty()) {
            result = this.getCurrentElementStack(namespaceURI).peek();
        }
        return result;
    }

    private Stack<String> getCurrentElementStack(String namespaceURI) {
        Stack<String> currentElementStack = this.currentElementStacks.get(namespaceURI);
        if (currentElementStack == null) {
            currentElementStack = new Stack();
            currentElementStack.push("");
            this.currentElementStacks.put(namespaceURI, currentElementStack);
        }
        return currentElementStack;
    }

    @Override
    public void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
    }
}

