/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.sax;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.DocumentEventReceiver;
import xmldoc.DocumentLocation;
import xmldoc.NamespacePrefixMapper;
import xmldoc.SimpleElementReference;
import xmldoc.sax.AbstractDocumentHandler;
import xmldoc.sax.DocumentErrorPostProcessor;
import xmldoc.sax.SAXExceptionDecoder;
import xmldoc.sax.XPathLocationStack;

public class DocumentHandlerImpl2
extends AbstractDocumentHandler
implements DocumentErrorPostProcessor {
    private final List<Fixup> fixups = new ArrayList<Fixup>();
    private final XPathLocationStack xPathLocationStack = new XPathLocationStack();

    public DocumentHandlerImpl2(DocumentEventReceiver docEventReceiver, boolean includePrefixesInXPaths) {
        super(docEventReceiver);
        this.xPathLocationStack.setIncludePrefixesInXPathLocatorStrings(includePrefixesInXPaths);
        this.docEventReceiver.setXPathLocator(this.xPathLocationStack);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.checkTerminated();
        String previousNamespaceURI = this.xPathLocationStack.getCurrentNamespace();
        this.xPathLocationStack.push(namespaceURI, localName);
        for (Fixup fixup : this.fixups) {
            fixup.error.setXPathLocation(this.xPathLocationStack.toXPathLocatorString());
        }
        this.fixups.clear();
        if (!this.xPathLocationStack.getCurrentNamespace().equals(previousNamespaceURI)) {
            this.docEventReceiver.startNamespace(namespaceURI);
        }
        this.currentElementRef = SimpleElementReference.makeReference(this.xPathLocationStack.getCurrentXPath());
        this.docEventReceiver.startElement(this.currentElementRef, this.createAttributeArray(attributes));
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkTerminated();
        this.docEventReceiver.endElement(this.currentElementRef);
        this.xPathLocationStack.pop();
        if (!namespaceURI.equals(this.xPathLocationStack.getCurrentNamespace())) {
            this.docEventReceiver.endNamespace(namespaceURI);
        }
        this.removeFixupsOfType(DocumentErrorPostProcessor.FixupType.UntilEndElement);
        this.currentElementRef = SimpleElementReference.makeReference(this.xPathLocationStack.getCurrentXPath());
    }

    private void removeFixupsOfType(DocumentErrorPostProcessor.FixupType fixupType) {
        ArrayList<Fixup> toRemove = new ArrayList<Fixup>();
        for (Fixup fixup : this.fixups) {
            if (fixup.type != fixupType) continue;
            toRemove.add(fixup);
        }
        this.fixups.removeAll(toRemove);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.checkTerminated();
        this.docEventReceiver.elementText(this.currentElementRef, ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.checkTerminated();
        this.docEventReceiver.endDocument();
    }

    @Override
    protected DocumentError createDocumentError(SAXParseException ex) {
        DocumentError error = this.exceptionDecoder.decodeException(this.currentElementRef, ex);
        error.setLocation(new DocumentLocation(ex, error.getElementReference()));
        Object extraInfo = this.getErrorCollector().getErrorExtraInfo();
        error.setExtraInfo(extraInfo);
        error.setXPathLocation(this.xPathLocationStack.toXPathLocatorString());
        return error;
    }

    @Override
    public void setExceptionDecoder(SAXExceptionDecoder exceptionDecoder) {
        super.setExceptionDecoder(exceptionDecoder);
        exceptionDecoder.setDocumentErrorPostProcessor(this);
    }

    @Override
    public void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        this.xPathLocationStack.setNamespacePrefixMapper(namespacePrefixMapper);
    }

    @Override
    public void scheduleErrorForProcessing(DocumentError error, DocumentErrorPostProcessor.FixupType type) {
        this.fixups.add(new Fixup(error, type));
    }

    @Override
    public void scheduleErrorForProcessing(DocumentError error) {
        this.fixups.add(new Fixup(error, DocumentErrorPostProcessor.FixupType.UntilStartElement));
    }

    protected class Fixup {
        private final DocumentError error;
        private final DocumentErrorPostProcessor.FixupType type;

        public Fixup(DocumentError error, DocumentErrorPostProcessor.FixupType type) {
            this.error = error;
            this.type = type;
        }

        public DocumentError getError() {
            return this.error;
        }

        public DocumentErrorPostProcessor.FixupType getType() {
            return this.type;
        }
    }
}

