/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.sax;

import java.util.HashMap;
import java.util.Map;
import xmldoc.NamespacePrefixMapper;

public class SimpleNamespacePrefixMapper
implements NamespacePrefixMapper {
    private static final String[][] prefixMapData = new String[][]{{"http://www.govtalk.gov.uk/CM/envelope", "hd"}, {"http://www.w3.org/2000/09/xmldsig#", "dsig"}};
    private final Map<String, String> namespaceToPrefixMap = new HashMap<String, String>();
    private final Map<String, String> prefixToNamespaceMap = new HashMap<String, String>();

    public SimpleNamespacePrefixMapper() {
        this(prefixMapData);
    }

    public SimpleNamespacePrefixMapper(String[][] initializationData) {
        this.addMappings(initializationData);
    }

    @Override
    public String mapNamespaceToPrefix(String namespace) {
        return this.namespaceToPrefixMap.get(namespace);
    }

    @Override
    public String mapPrefixToNamespace(String prefix) {
        return this.prefixToNamespaceMap.get(prefix);
    }

    public void addMapping(String namespace, String prefix) {
        if (!this.namespaceToPrefixMap.containsKey(namespace)) {
            this.namespaceToPrefixMap.put(namespace, prefix);
            this.prefixToNamespaceMap.put(prefix, namespace);
        }
    }

    public void addMappings(String[][] mappings) {
        for (String[] element : mappings) {
            this.addMapping(element[0], element[1]);
        }
    }
}

