/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.sax;

import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import xmldoc.NamespacePrefixMapper;
import xmldoc.sax.XPathLocationStackFrame;
import xmldoc.sax.XPathLocator;

public class XPathLocationStack
implements XPathLocator,
Cloneable {
    private LinkedList<XPathLocationStackFrame> locationStack = new LinkedList();
    private NamespacePrefixMapper namespacePrefixMapper = null;
    private boolean includePrefixesInXPathLocatorStrings = true;

    public Object clone() {
        XPathLocationStack clone = new XPathLocationStack();
        clone.includePrefixesInXPathLocatorStrings = this.includePrefixesInXPathLocatorStrings;
        clone.namespacePrefixMapper = this.namespacePrefixMapper;
        clone.locationStack = new LinkedList();
        for (XPathLocationStackFrame frame : this.locationStack) {
            clone.locationStack.add(frame.clone());
        }
        return clone;
    }

    public NamespacePrefixMapper getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    public void setIncludePrefixesInXPathLocatorStrings(boolean includePrefixesInXPathLocatorStrings) {
        this.includePrefixesInXPathLocatorStrings = includePrefixesInXPathLocatorStrings;
    }

    public boolean isIncludePrefixesInXPathLocatorStrings() {
        return this.includePrefixesInXPathLocatorStrings;
    }

    private XPathLocationStackFrame getCurrentStackFrame() {
        if (this.locationStack.isEmpty()) {
            return null;
        }
        return this.locationStack.getLast();
    }

    public String getCurrentNamespace() {
        XPathLocationStackFrame frame = this.getCurrentStackFrame();
        return frame != null ? frame.getNamespace() : null;
    }

    public String getCurrentXPath() {
        XPathLocationStackFrame frame = this.getCurrentStackFrame();
        return frame != null ? frame.getXPath() : null;
    }

    @Override
    public String toXPathLocatorString() {
        String result = "";
        for (XPathLocationStackFrame stackFrame : this.locationStack) {
            String elementName = this.includePrefixesInXPathLocatorStrings ? stackFrame.getPrefixedElementName() : stackFrame.getElementName();
            result = result + "/" + elementName + "[" + stackFrame.getElementIndex() + "]";
        }
        return result;
    }

    public String toString() {
        return this.toXPathLocatorString();
    }

    public void pop() {
        try {
            this.locationStack.removeLast();
        }
        catch (NoSuchElementException e) {
            throw new EmptyStackException();
        }
    }

    public void push(String elementName) {
        this.push(null, elementName);
    }

    public void push(String namespace, String elementName) {
        String prefixedElementName = elementName;
        if (this.namespacePrefixMapper != null) {
            String prefix = this.namespacePrefixMapper.mapNamespaceToPrefix(namespace);
            prefixedElementName = (prefix != null ? prefix + ":" : "") + elementName;
        }
        this.locationStack.addLast(new XPathLocationStackFrame(this.getCurrentStackFrame(), namespace, elementName, prefixedElementName));
    }
}

