/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.sax;

import java.util.HashMap;
import java.util.Map;

class XPathLocationStackFrame
implements Cloneable {
    private static final Integer ONE = new Integer(1);
    private final Map<String, Integer> childElementCounts = new HashMap<String, Integer>();
    private final String namespace;
    private final String prefixedElementName;
    private final String elementName;
    private int index = 1;
    private String xPath;

    public XPathLocationStackFrame(XPathLocationStackFrame parent, String namespace, String elementName, String prefixedElementName) {
        this.namespace = namespace;
        this.elementName = elementName;
        this.prefixedElementName = prefixedElementName;
        if (parent != null) {
            this.index = XPathLocationStackFrame.countChildren(parent, elementName);
        }
        this.xPath = (parent == null ? "/" : parent.xPath + "/") + prefixedElementName;
    }

    public XPathLocationStackFrame clone() {
        XPathLocationStackFrame clonedFrame = new XPathLocationStackFrame(null, this.namespace, this.elementName, this.prefixedElementName);
        clonedFrame.xPath = this.xPath;
        clonedFrame.index = this.index;
        clonedFrame.childElementCounts.putAll(this.childElementCounts);
        return clonedFrame;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getPrefixedElementName() {
        return this.prefixedElementName;
    }

    public int getElementIndex() {
        return this.index;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getXPath() {
        return this.xPath;
    }

    private static int countChildren(XPathLocationStackFrame frame, String elementName) {
        int newCount = 1;
        if (frame != null) {
            Integer elementCount = frame.childElementCounts.get(elementName);
            if (elementCount != null) {
                newCount = elementCount + 1;
                frame.childElementCounts.put(elementName, new Integer(newCount));
            } else {
                frame.childElementCounts.put(elementName, ONE);
            }
        }
        return newCount;
    }
}

