/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.util;

import com.gsl.logging.LoggerFactory;
import java.util.logging.Logger;
import xmldoc.util.EntityResolutionMap;
import xmldoc.util.EntityResolutionMapBuilder;
import xmldoc.util.EntityResolver;

public abstract class AbstractEntityResolver
implements EntityResolver {
    private Logger logger;
    protected final EntityResolutionMap entityResolutionMap;
    private final String name;

    protected AbstractEntityResolver() {
        this(null);
    }

    protected AbstractEntityResolver(String name, String[][] entityResolutionTable) {
        EntityResolutionMapBuilder mapBuilder = new EntityResolutionMapBuilder();
        mapBuilder.add(entityResolutionTable);
        this.name = name;
        this.entityResolutionMap = mapBuilder.makeEntityResolutionMap();
    }

    protected AbstractEntityResolver(EntityResolutionMap entityResolutionMap) {
        this.entityResolutionMap = entityResolutionMap;
        this.name = "anonymous";
    }

    protected AbstractEntityResolver(String name, EntityResolutionMap entityResolutionMap) {
        this.name = name;
        this.entityResolutionMap = entityResolutionMap;
    }

    @Override
    public EntityResolutionMap getMap() {
        return this.entityResolutionMap;
    }

    @Override
    public String getExternalSchemaLocations() {
        return this.entityResolutionMap.getExternalSchemaLocations();
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger("xmldoc.util.entityResolver");
        }
        return this.logger;
    }

    public String toString() {
        return "EntityResolver: " + this.name;
    }
}

