/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.util;

import com.gsl.io.core.stream.StreamUtils;
import com.gsl.io.core.stream.Streamable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xmldoc.util.AbstractEntityResolver;
import xmldoc.util.EntityResolutionMap;

public class CachingFileSystemEntityResolver
extends AbstractEntityResolver {
    private final Map<String, byte[]> entityUriToByteArrayMap = new HashMap<String, byte[]>();

    public CachingFileSystemEntityResolver(EntityResolutionMap entityResolutionMap) throws SAXException {
        super(entityResolutionMap);
        Iterator<Map.Entry<String, Streamable>> i = entityResolutionMap.getStreamableEntrySetIterator();
        while (i.hasNext()) {
            Map.Entry<String, Streamable> entry = i.next();
            String entityUri = entry.getKey();
            Streamable entityStreamable = entry.getValue();
            byte[] bytes = null;
            try {
                bytes = StreamUtils.readAllBytesFromStream(entityStreamable.openInputStream());
            }
            catch (IOException ioEx) {
                this.getLogger().log(Level.SEVERE, "Could not load schema file " + entityStreamable.toString() + " for namespace " + entityUri, ioEx);
                throw new SAXException("Could not load schema file " + entityStreamable.toString() + " for namespace " + entityUri, ioEx);
            }
            this.entityUriToByteArrayMap.put(entityUri, bytes);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        byte[] bytes;
        InputSource resolvedInputSource = null;
        if (systemId != null && (bytes = this.entityUriToByteArrayMap.get(systemId)) != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            resolvedInputSource = new InputSource(stream);
        }
        return resolvedInputSource;
    }
}

