/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.util;

import java.io.InputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xmldoc.util.AbstractEntityResolver;

public class ClasspathEntityResolver
extends AbstractEntityResolver {
    public ClasspathEntityResolver(String name, String[][] entityResolutionTable) {
        super(name, entityResolutionTable);
    }

    public ClasspathEntityResolver(String[][] entityResolutionTable) {
        super("anonymous", entityResolutionTable);
    }

    public void addTableEntry(String namespace, String xsdPath) {
        this.getMap().addLocationEntry(namespace, xsdPath);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource resolvedInputSource = null;
        String entityLocation = this.entityResolutionMap.getLocationFor(systemId);
        if (entityLocation != null) {
            InputStream stream = this.getClass().getResourceAsStream(entityLocation);
            if (stream != null) {
                resolvedInputSource = new InputSource(stream);
            } else {
                this.getLogger().severe("Could not load schema file " + entityLocation + " for namespace " + systemId);
                throw new SAXException("Could not load schema file " + entityLocation + " for namespace " + systemId);
            }
        }
        return resolvedInputSource;
    }
}

