/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.util;

import com.gsl.io.core.stream.Streamable;
import java.util.Iterator;
import java.util.Map;

public class EntityResolutionMap {
    private final Map<String, String> uriToLocationMap;
    private final Map<String, Streamable> uriToStreamableMap;

    public EntityResolutionMap(Map<String, String> uriToLocationMap, Map<String, Streamable> uriToNamedInputStreamMap) {
        this.uriToLocationMap = uriToLocationMap;
        this.uriToStreamableMap = uriToNamedInputStreamMap;
    }

    public boolean containsRow(String uri, String location) {
        String mapEntryLocation = this.uriToLocationMap.get(uri);
        return mapEntryLocation != null && mapEntryLocation.endsWith(location);
    }

    public String getLocationFor(String uri) {
        return this.uriToLocationMap.get(uri);
    }

    public Iterator<Map.Entry<String, String>> getLocationEntrySetIterator() {
        return this.uriToLocationMap.entrySet().iterator();
    }

    public Iterator<Map.Entry<String, Streamable>> getStreamableEntrySetIterator() {
        return this.uriToStreamableMap.entrySet().iterator();
    }

    public String getExternalSchemaLocations() {
        StringBuffer buffer = new StringBuffer(512);
        for (String uri : this.uriToLocationMap.keySet()) {
            buffer.append(uri).append(" ").append(uri).append(" ");
        }
        return buffer.toString();
    }

    public void addLocationEntry(String namespace, String xsdPath) {
        this.uriToLocationMap.put(namespace, xsdPath);
    }
}

