/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.util;

import com.gsl.io.core.stream.Streamable;
import com.gsl.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import xmldoc.util.EntityResolutionMap;

public class EntityResolutionMapBuilder {
    protected final Map<String, String> uriToLocationMap = new HashMap<String, String>();
    protected final Map<String, Streamable> uriToNamedInputStreamMap = new HashMap<String, Streamable>();
    private final Logger logger = LoggerFactory.getLogger("EntityResolutionMapBuilder");

    public void add(String[][] uriToLocationTable) {
        for (String[] row : uriToLocationTable) {
            this.add(row[0], row[1]);
        }
    }

    public void add(String uri, String filepath) {
        if (!uri.trim().equals("")) {
            if (this.uriToLocationMap.containsKey(uri)) {
                this.logger.severe("Namespace '" + uri + "' is already mapped to file " + this.uriToLocationMap.get(uri) + ", attempting to remap to " + filepath);
            }
            this.uriToLocationMap.put(uri, filepath);
        }
    }

    public void add(String uri, Streamable schema) {
        if (!uri.trim().equals("")) {
            if (this.uriToNamedInputStreamMap.containsKey(uri)) {
                this.logger.severe("Namespace '" + uri + "' is already mapped to a schema");
            }
            this.uriToNamedInputStreamMap.put(uri, schema);
        }
    }

    public EntityResolutionMap makeEntityResolutionMap() {
        return new EntityResolutionMap(this.uriToLocationMap, this.uriToNamedInputStreamMap);
    }
}

