/*
 * Decompiled with CFR 0.152.
 */
package xmldoc.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xmldoc.util.AbstractEntityResolver;
import xmldoc.util.EntityResolutionMap;

public class FileSystemEntityResolver
extends AbstractEntityResolver {
    public FileSystemEntityResolver(EntityResolutionMap entityResolutionMap) {
        super(entityResolutionMap);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource resolvedInputSource = null;
        String entityLocation = this.entityResolutionMap.getLocationFor(systemId);
        if (entityLocation != null) {
            try {
                FileInputStream stream = new FileInputStream(entityLocation);
                resolvedInputSource = new InputSource(stream);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not load schema file " + entityLocation + " for namespace " + systemId, e);
                throw new SAXException("Could not load schema file " + entityLocation + " for namespace " + systemId, e);
            }
        }
        return resolvedInputSource;
    }
}

