/*
 * Decompiled with CFR 0.152.
 */
package hmrc.middleware.config.file;

import hmrc.middleware.config.file.XMLFile;
import java.io.File;
import java.util.ArrayList;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class XMLDirectory {
    private String file;
    private long lastModifiedDate;
    private ArrayList<XMLFile> files = new ArrayList();
    private ArrayList<XMLDirectory> directory = new ArrayList();

    XMLDirectory(File file) {
        File[] children;
        this.file = file.getAbsolutePath();
        this.lastModifiedDate = file.lastModified();
        for (File child : children = file.listFiles()) {
            if (child.isDirectory()) {
                XMLDirectory directory = new XMLDirectory(child);
                this.directory.add(directory);
                continue;
            }
            if (!child.getName().endsWith(".xml")) continue;
            XMLFile xmlFile = new XMLFile(child);
            this.files.add(xmlFile);
        }
    }

    public boolean hasChanged() {
        if (this.exists()) {
            int x;
            File file = new File(this.file);
            if (file.lastModified() != this.lastModifiedDate) {
                return true;
            }
            for (x = 0; x < this.files.size(); ++x) {
                if (!this.files.get(x).hasChanged()) continue;
                return true;
            }
            for (x = 0; x < this.directory.size(); ++x) {
                boolean changed = this.directory.get(x).hasChanged();
                if (!changed) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    void toXML(XMLBuilder builder) {
        System.out.println(">> Location: " + this.file);
        if (this.exists()) {
            int x;
            for (x = 0; x < this.files.size(); ++x) {
                this.files.get(x).toXML(builder);
            }
            for (x = 0; x < this.directory.size(); ++x) {
                this.directory.get(x).toXML(builder);
            }
        }
    }

    private boolean exists() {
        File file = new File(this.file);
        return file.exists();
    }

    public int getTotalFilesRead() {
        int count = 0;
        count += this.files.size();
        for (int x = 0; x < this.directory.size(); ++x) {
            count += this.directory.get(x).getTotalFilesRead();
        }
        return count;
    }
}

