/*
 * Decompiled with CFR 0.152.
 */
package hmrc.middleware.config.file;

import hmrc.middleware.config.file.MiddlewareFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import uk.gov.hmrc.chris.ChRISExceptionLogger;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class XMLFile {
    private String file;
    private long lastModifiedDate;

    XMLFile(File file) {
        this.file = file.getAbsolutePath();
        this.lastModifiedDate = file.lastModified();
    }

    public boolean hasChanged() {
        File file = new File(this.file);
        return this.lastModifiedDate != file.lastModified();
    }

    private boolean exists() {
        File file = new File(this.file);
        return file.exists();
    }

    void toXML(XMLBuilder builder) {
        if (this.exists()) {
            try {
                builder.writeStartElement("File");
                builder.writeAttribute("filename", this.file);
                FileInputStream source = null;
                try {
                    File file = new File(this.file);
                    source = new FileInputStream(file);
                    builder.AppendDocument(source);
                    System.out.println(">>     File: " + file.getName());
                }
                catch (FileNotFoundException e) {
                    throw new MiddlewareFileException("Could not get a stream to the file: " + this.file, e);
                }
                builder.writeEndElement();
            }
            catch (XMLBuilder.XMLBuilderException e) {
                ChRISExceptionLogger.error("Could not append XML docuemtn for file: " + this.file);
                throw new MiddlewareFileException("Could not append XML docuemtn for file: " + this.file, e);
            }
        }
    }
}

