/*
 * Decompiled with CFR 0.152.
 */
package hmrc.middleware.config.file;

import hmrc.middleware.config.file.MiddlewareFileException;
import hmrc.middleware.config.file.XMLDirectory;
import hmrc.middleware.config.utils.PropertiesLoader;
import ir.middleware.Common.MWWorkTask;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import uk.gov.hmrc.chris.ChRISExceptionLogger;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class XMLFileController
extends MWWorkTask {
    private static XMLFileController controller = new XMLFileController();
    private XMLDirectory root;
    private byte[] xmlData;
    private Timer timer = new Timer();

    private XMLFileController() {
        this.root = this.getConfigFiles();
        this.buildXML();
        this.timer.schedule((TimerTask)((Object)this), 30000L, 3000L);
    }

    public InputStream getXMLData() {
        for (int retry = 0; this.xmlData == null && retry < 5; ++retry) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                throw new MiddlewareFileException("Could not pause thread to allow config to be loaded", e);
            }
        }
        return new ByteArrayInputStream(this.xmlData);
    }

    private XMLDirectory getConfigFiles() {
        File fileLocation;
        String serviceConfigFilesDir = null;
        String configFilesDir = System.getProperty("configxmldir");
        if (configFilesDir == null || configFilesDir.equals("")) {
            throw new MiddlewareFileException("The jvm option -Dconfigxmldir has not been set so xml config files cannot be read.");
        }
        serviceConfigFilesDir = configFilesDir;
        Properties props = PropertiesLoader.loadProperties();
        String folderName = props.getProperty("FOLDER.NAME");
        if (folderName != null && !folderName.equals("")) {
            serviceConfigFilesDir = serviceConfigFilesDir + "/" + folderName;
        }
        if (!(fileLocation = new File(serviceConfigFilesDir)).isDirectory()) {
            throw new MiddlewareFileException("File location " + serviceConfigFilesDir + " is not a directory");
        }
        XMLDirectory root = new XMLDirectory(fileLocation);
        return root;
    }

    public static XMLFileController getController() {
        return controller;
    }

    private void buildXML() {
        System.out.println(">> Loaded Config File Stats");
        System.out.println(">> -----------------");
        try {
            XMLBuilder builder = new XMLBuilder();
            builder.writeStartElement("MiddlewareConfigWrapper");
            this.root.toXML(builder);
            builder.writeEndElement();
            this.xmlData = builder.getBytesAsNewData();
            System.out.println(">> Total number of XML files loaded: " + this.root.getTotalFilesRead());
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new MiddlewareFileException("Could not write XML document for configuration files", e);
        }
    }

    public void run() {
        if (this.root.hasChanged()) {
            System.out.println(">> -----------------");
            System.out.println(">> Updated Config - Files Will Be Reloaded");
            System.out.println(">> -----------------");
            byte[] localData = this.xmlData;
            try {
                this.root = this.getConfigFiles();
                this.buildXML();
            }
            catch (Exception e) {
                this.xmlData = localData;
                ChRISExceptionLogger.error("Cannot generate XML config file, probably due to corrupt xml config file, reloaded old config");
                ChRISExceptionLogger.error(e.getMessage());
            }
        }
    }
}

