/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris;

import ir.middleware.ExceptionManager.ExceptionManager;
import ir.middleware.ExceptionManager.IRException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.SystemUtils;
import uk.gov.hmrc.chris.ChRISBaseLogger;
import uk.gov.hmrc.chris.IncidentException;

public class ChRISIncidentLogger
extends ChRISBaseLogger {
    private static final String SEE_BELOW_MESSAGE = "see below";
    private static final int MESSAGE_SET_NUMBER = 61;
    private static final int MESSAGE_ERROR_NUMBER = 1;
    private static final int MESSAGE_WARNING_NUMBER = 1011;

    public static String generateIncidentFile(Exception e) {
        String errorId = ChRISIncidentLogger.generateErorId();
        IRException irExp = ExceptionManager.reportException((int)61, (int)1, (String[])new String[]{ChRISIncidentLogger.formatErrorId(errorId), e.getMessage()}, (String)SEE_BELOW_MESSAGE, (String)SEE_BELOW_MESSAGE, (Throwable)e, IncidentException.class);
        if (irExp instanceof IncidentException) {
            return errorId;
        }
        return null;
    }

    public static String generateWarningFile(Exception e) {
        String errorId = ChRISIncidentLogger.generateErorId();
        IRException irExp = ExceptionManager.reportWarning((int)61, (int)1011, (String[])new String[]{ChRISIncidentLogger.formatErrorId(errorId), e.getMessage()}, (String)SEE_BELOW_MESSAGE, (String)SEE_BELOW_MESSAGE, (Throwable)e, IncidentException.class);
        if (irExp instanceof IncidentException) {
            return errorId;
        }
        return null;
    }

    private static String generateErorId() {
        return RandomStringUtils.randomAlphanumeric((int)16).toUpperCase();
    }

    private static String formatErrorId(String errorId) {
        return SystemUtils.LINE_SEPARATOR + SystemUtils.LINE_SEPARATOR + "INCIDENT_ID" + " :" + errorId + SystemUtils.LINE_SEPARATOR;
    }
}

