/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.dao.tracking;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.dao.tracking.ITrackingDAOFactory;
import uk.gov.hmrc.chris.dao.tracking.TrackingDAOException;
import uk.gov.hmrc.chris.dao.tracking.TrackingDTO;
import uk.gov.hmrc.chris.utils.resoucehandler.ConnectionHandler;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceForman;
import uk.gov.hmrc.chris.utils.transaction.JTATransactionCoordinator;

public class TrackingDAO {
    private static final String TRACKING_TABLE = "TRACKING_EVENT";
    private static final String TRACKING_TABLE_CONVERSATION_ID_COL = "CONVERSATION_ID";
    private static final String TRACKING_TABLE_EVENT_CODE_COL = "EVENT_CODE";
    private static final String TRACKING_TABLE_EVENT_TIMESTAMP = "CREATION_TIMESTAMP";
    private static final String TRACKING_DOCUMENT_TABLE = "TRACKING_DATA";
    private static final String TRACKING_DOCUMENT_TABLE_CONVERSATION_ID_COL = "CONVERSATION_ID";
    private static final String TRACKING_DOCUMENT_TABLE_DOCUMENT_COL = "TRACKING_DOC";
    private String datasource;
    private static ITrackingDAOFactory factory;

    private TrackingDAO(String datasource) {
        this.datasource = datasource;
    }

    public static void reset() {
        factory = new ITrackingDAOFactory(){

            @Override
            public TrackingDAO create(String datasource) {
                return new TrackingDAO(datasource);
            }
        };
    }

    public static TrackingDAO create(String datasource) {
        return factory.create(datasource);
    }

    public static void setFactory(ITrackingDAOFactory factory) {
        TrackingDAO.factory = factory;
    }

    public void setEvent(TrackingDTO dto) {
        JTATransactionCoordinator.notifyTransactionRequired();
        String sql = "insert into TRACKING_EVENT ( CONVERSATION_ID,EVENT_CODE,CREATION_TIMESTAMP ) values ( ?,?,?)";
        ConnectionHandler connection = ResourceForman.getInstance().getConnectionHandler();
        PreparedStatement statement = null;
        try {
            JTATransactionCoordinator.notifyTransactionRequired();
            statement = connection.getPreparedStatement(sql, this.datasource);
            statement.setObject(1, (Object)dto.getConversationID(), 12);
            statement.setObject(2, (Object)dto.getEventCode(), 2);
            statement.setObject(3, (Object)new Timestamp(dto.getEventTimeStamp().getTime()), 93);
            statement.executeQuery();
        }
        catch (SQLException e) {
            throw new TrackingDAOException("Datasource driver is: " + connection.getDriverVersion(this.datasource) + "Could not create prepared statement with sql " + sql, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    ChRISLogger.warning("Could not close the statement.  Error message is: " + e.getMessage());
                }
            }
        }
    }

    public TrackingDTO[] getEvents(TrackingDTO dto) {
        String sql = "select * from TRACKING_EVENT where CONVERSATION_ID =  ?";
        ConnectionHandler connection = ResourceForman.getInstance().getConnectionHandler();
        PreparedStatement statement = null;
        ArrayList<TrackingDTO> events = new ArrayList<TrackingDTO>();
        try {
            statement = connection.getPreparedStatement(sql, this.datasource);
            statement.setObject(1, (Object)dto.getConversationID(), 12);
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                TrackingDTO event = new TrackingDTO();
                event.setConversationID(dto.getConversationID());
                event.setEventCode(results.getInt(TRACKING_TABLE_EVENT_CODE_COL));
                event.setEventTimeStamp(results.getTimestamp(TRACKING_TABLE_EVENT_TIMESTAMP));
                events.add(event);
            }
        }
        catch (SQLException e) {
            throw new TrackingDAOException("Datasource driver is: " + connection.getDriverVersion(this.datasource) + "Could not create prepared statement with sql " + sql, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    ChRISLogger.warning("Could not close the statement.  Error message is: " + e.getMessage());
                }
            }
        }
        return events.toArray(new TrackingDTO[0]);
    }

    public boolean checkEvent(TrackingDTO dto) {
        String sql = "select * from TRACKING_EVENT where CONVERSATION_ID  =  ? and EVENT_CODE = ?";
        ConnectionHandler connection = ResourceForman.getInstance().getConnectionHandler();
        PreparedStatement statement = null;
        try {
            statement = connection.getPreparedStatement(sql, this.datasource);
            statement.setObject(1, (Object)dto.getConversationID(), 12);
            statement.setObject(2, (Object)dto.getEventCode(), 2);
            ResultSet results = statement.executeQuery();
            boolean bl = results.next();
            return bl;
        }
        catch (SQLException e) {
            throw new TrackingDAOException("Datasource driver is: " + connection.getDriverVersion(this.datasource) + "Could not create prepared statement with sql " + sql, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    ChRISLogger.warning("Could not close the statement.  Error message is: " + e.getMessage());
                }
            }
        }
    }

    public boolean checkEvents(TrackingDTO[] dtos) {
        if (dtos == null || dtos.length == 0) {
            throw new TrackingDAOException("Null or empty Tracking DTO parameter");
        }
        if (dtos.length == 1) {
            return this.checkEvent(dtos[0]);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select conversation_id from TRACKING_EVENT");
        sql.append(" where CONVERSATION_ID  =  ? and ");
        sql.append("EVENT_CODE IN (");
        for (int i = 0; i < dtos.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        ConnectionHandler connection = ResourceForman.getInstance().getConnectionHandler();
        PreparedStatement statement = null;
        try {
            statement = connection.getPreparedStatement(sql.toString(), this.datasource);
            statement.setObject(1, (Object)dtos[0].getConversationID(), 12);
            for (int j = 0; j < dtos.length; ++j) {
                statement.setObject(j + 2, (Object)dtos[j].getEventCode(), 2);
            }
            ResultSet results = statement.executeQuery();
            boolean bl = results.next();
            return bl;
        }
        catch (SQLException e) {
            throw new TrackingDAOException("Datasource driver is: " + connection.getDriverVersion(this.datasource) + "Could not create prepared statement with sql " + sql, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    ChRISLogger.warning("Could not close the statement.  Error message is: " + e.getMessage());
                }
            }
        }
    }

    static {
        TrackingDAO.reset();
    }
}

