/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.esb.broker;

import ir.middleware.ResourceManager.BRCManager.IRBRCListenerEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import uk.gov.hmrc.chris.ChRISLogger;
import uk.gov.hmrc.chris.UtilitiesException;

public abstract class _AListener
extends IRBRCListenerEvent {
    protected static final String USER_TRANSACTION = "java:comp/UserTransaction";
    private static final String SERVICE_PROPERTIES_FILE = "service.properties";
    private static Properties props = null;
    private static Context context = null;

    protected InputStream getPayloadAsInputStream(byte[] msg) throws IOException {
        if (msg != null) {
            return new ByteArrayInputStream(msg);
        }
        return null;
    }

    protected InputStream getPayloadAsInputStream(String msg) throws IOException {
        InputStream is = null;
        if (msg != null) {
            is = this.getPayloadAsInputStream(msg.getBytes("UTF-8"));
        }
        return is;
    }

    protected static Properties getProperties() throws UtilitiesException {
        if (props != null) {
            return props;
        }
        return _AListener.getProps();
    }

    private static synchronized Properties getProps() throws UtilitiesException {
        if (props != null && !props.isEmpty()) {
            return props;
        }
        Properties localProps = new Properties();
        InputStream is = null;
        try {
            is = _AListener.class.getClassLoader().getResourceAsStream(SERVICE_PROPERTIES_FILE);
            localProps.load(is);
            props = localProps;
        }
        catch (IOException e) {
            throw new UtilitiesException("Could not load properties file", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    ChRISLogger.warning("Cannot close input stream in PayeMOVRequestListener.");
                }
            }
        }
        return props;
    }

    protected Context getInitialContext() throws NamingException {
        if (context != null) {
            return context;
        }
        _AListener.createInitialContext();
        return context;
    }

    private static final synchronized void createInitialContext() throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
    }
}

