/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.logger;

import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import uk.gov.hmrc.chris.logger.MiddlewareIncidentHandler;
import uk.gov.hmrc.chris.logger.WeblogicLoggerHandler;

public class HandlerFactory {
    private static final Level levelFinest = Level.FINEST;
    private static final Level levelSevere = Level.SEVERE;
    private static String mainHandlerType = "Weblogic";
    private static String incidentHandlerType = "Middleware";

    public static Handler[] getHandlers(String name) {
        ArrayList<Handler> handlerArrayList = new ArrayList<Handler>();
        handlerArrayList.add(HandlerFactory.getMainHandler(name));
        handlerArrayList.add(HandlerFactory.getIncidentHandler(name));
        return handlerArrayList.toArray(new Handler[handlerArrayList.size()]);
    }

    private static Handler getMainHandler(String name) {
        WeblogicLoggerHandler mainHandler = null;
        if (mainHandlerType.equals("Weblogic")) {
            mainHandler = new WeblogicLoggerHandler(name);
            mainHandler.setLevel(levelFinest);
        }
        return mainHandler;
    }

    private static Handler getIncidentHandler(String name) {
        MiddlewareIncidentHandler incidentHandler = null;
        if (incidentHandlerType.equals("Middleware")) {
            incidentHandler = new MiddlewareIncidentHandler(name);
            incidentHandler.setLevel(levelSevere);
        }
        return incidentHandler;
    }
}

