/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.logger;

import ir.middleware.ExceptionManager.IRException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class MiddlewareExceptionAdapter
extends IRException {
    private static final long serialVersionUID = 1L;

    public MiddlewareExceptionAdapter(String message, String failingClass, String failingMethod, Throwable previousException, Level severity) {
        super(message);
        this.setStackTrace(new StackTraceElement[0]);
        this.setSeverity(this.mapSeverity(severity));
        this.msgNum = 100001;
        this.msgSet = 91;
        this.container = "ChRIS";
        this.failingClass = failingClass == null ? "unknown" : failingClass;
        this.failingMethod = failingMethod == null ? "unknown" : failingMethod;
        try {
            this.failingHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhex) {
            this.failingHost = "unknown";
        }
    }

    private int mapSeverity(Level sev) {
        if (sev.equals(Level.SEVERE)) {
            return 1;
        }
        if (sev.equals(Level.WARNING)) {
            return 2;
        }
        return 3;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public void printStackTrace(PrintStream s) {
    }

    public void printStackTrace(PrintWriter s) {
    }
}

