/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.logger;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import uk.gov.hmrc.chris.logger.LogMessageFormatter;
import weblogic.logging.NonCatalogLogger;

public class WeblogicLoggerHandler
extends Handler {
    private NonCatalogLogger nonCatalogLogger = null;
    private Formatter logFormatter = null;

    public WeblogicLoggerHandler(String name) {
        this.nonCatalogLogger = new NonCatalogLogger(name);
        this.logFormatter = new LogMessageFormatter();
        this.setFormatter(this.logFormatter);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String recordData = record.getMessage();
        if (record.getLevel().intValue() <= Level.CONFIG.intValue()) {
            this.nonCatalogLogger.debug(recordData);
        } else if (record.getLevel().intValue() <= Level.INFO.intValue()) {
            this.nonCatalogLogger.info(recordData);
        } else if (record.getLevel().intValue() <= Level.WARNING.intValue()) {
            this.nonCatalogLogger.warning(recordData);
        } else if (record.getLevel().intValue() <= Level.SEVERE.intValue()) {
            this.nonCatalogLogger.error(recordData);
        }
    }
}

