/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.utils.SPOXUtils;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.spox.xml.XPathMonitor;

public class SAXElementHandler
extends DefaultHandler
implements LexicalHandler {
    private static final String RESERVED_PREFIX = "xml";
    private static final String PREFIX_SEPARATION = ":";
    private boolean insideXpath = false;
    private int currentDepth;
    private XPathMonitor xpm = null;
    private Listener[] listeners = null;
    private boolean removeAllNamespaces;

    public SAXElementHandler(XPathMonitor xpm, Listener ... listeners) {
        this(ListenerNotificationType.FULL, xpm, listeners);
    }

    public SAXElementHandler(ListenerNotificationType listenerNotificationType, XPathMonitor xpm, Listener ... listeners) {
        this.removeAllNamespaces = listenerNotificationType == ListenerNotificationType.WITHOUT_NAMESPACES;
        this.xpm = xpm;
        this.listeners = listeners;
    }

    @Override
    public void endDocument() throws SAXException {
        this.triggerDocumentFinished();
    }

    @Override
    public void startDocument() throws SAXException {
        this.triggerDocumentStarted();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] data = new char[length];
        System.arraycopy(ch, start, data, 0, length);
        this.triggerCharsFound(data, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String elementName;
        String string = elementName = this.removeAllNamespaces ? SPOXUtils.stripNameSpaceFromNode(qName) : qName;
        if (this.insideXpath) {
            --this.currentDepth;
        }
        this.xpm.popOffElement();
        this.triggerEndNode(elementName);
        if (this.currentDepth < 1 && this.insideXpath) {
            this.triggerXpathFinished();
            this.insideXpath = false;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String elementName = this.removeAllNamespaces ? SPOXUtils.stripNameSpaceFromNode(qName) : qName;
        this.xpm.pushOnElement(elementName, this.getAttributes(atts));
        if (this.insideXpath) {
            ++this.currentDepth;
        } else {
            String match = this.xpm.checkForMatch();
            if (match != null) {
                this.triggerXpathFound(match);
                this.insideXpath = true;
                ++this.currentDepth;
            }
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (atts.getLength() > 0) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeQName = atts.getQName(i);
                boolean prefix = attributeQName.contains(PREFIX_SEPARATION);
                boolean reservedPrefix = attributeQName.startsWith(RESERVED_PREFIX);
                if (this.removeAllNamespaces) {
                    if (reservedPrefix || prefix) continue;
                    String attributeName = SPOXUtils.stripNameSpaceFromNode(attributeQName);
                    attributes.add(new Attribute(attributeName, atts.getValue(i)));
                    continue;
                }
                attributes.add(new Attribute(attributeQName, atts.getValue(i)));
            }
        }
        this.triggerStartNode(elementName, attributes.toArray(new Attribute[attributes.size()]));
    }

    protected Attribute[] getAttributes(Attributes atts) {
        Attribute[] attributes = null;
        if (atts.getLength() > 0) {
            attributes = new Attribute[atts.getLength()];
            for (int i = 0; i < atts.getLength(); ++i) {
                attributes[i] = new Attribute(atts.getQName(i), atts.getValue(i));
            }
        }
        return attributes;
    }

    private void triggerXpathFound(String xpath) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].xpathFound(xpath);
        }
    }

    private void triggerXpathFinished() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].xpathFinished();
        }
    }

    private void triggerCharsFound(char[] data, int size) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].characterDataFound(data, size);
        }
    }

    private void triggerDocumentStarted() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].documentStarted();
        }
    }

    private void triggerDocumentFinished() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].documentFinished();
        }
    }

    private void triggerStartNode(String name, Attribute ... attributes) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].startElementFound(name, attributes);
        }
    }

    private void triggerEndNode(String name) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].endElementFound(name);
        }
    }

    private void triggerCommentFound(char[] arg0, int arg1, int arg2) {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].commentFound(arg0, arg1, arg2);
        }
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        this.triggerCommentFound(arg0, arg1, arg2);
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    public static enum ListenerNotificationType {
        FULL,
        WITHOUT_NAMESPACES;

    }
}

