/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.SAXElementHandler;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.xml.XPathMonitor;

public class XMLHandler {
    private XPathMonitor xpm = null;
    private Listener[] listeners = null;
    private SAXElementHandler.ListenerNotificationType listenerNotificationType;
    private static SAXParserFactory factory = SAXParserFactory.newInstance();

    public XMLHandler(Listener ... listeners) {
        this(SAXElementHandler.ListenerNotificationType.FULL, listeners);
    }

    public XMLHandler(SAXElementHandler.ListenerNotificationType listenerNotificationType, Listener ... listeners) {
        this.listenerNotificationType = listenerNotificationType;
        this.listeners = listeners;
        this.processListeners();
    }

    private void processListeners() {
        this.xpm = new XPathMonitor();
        for (int i = 0; i < this.listeners.length; ++i) {
            Listener l = this.listeners[i];
            String[] xpaths = l.getXPaths();
            this.xpm.addXpath(xpaths);
        }
    }

    public void readXML(InputStream is) throws SPOXException {
        SAXElementHandler handler = new SAXElementHandler(this.listenerNotificationType, this.xpm, this.listeners);
        XMLReader sp = null;
        try {
            sp = factory.newSAXParser().getXMLReader();
            sp.setContentHandler(handler);
            sp.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            sp.parse(new InputSource(is));
        }
        catch (SAXException e) {
            throw new SPOXException("Parser has reported an error to SPOX ", e);
        }
        catch (ParserConfigurationException e) {
            throw new SPOXException("Parser has reported an error to SPOX ", e);
        }
        catch (IOException e) {
            throw new SPOXException("IO Exception detected in SPOX ", e);
        }
    }

    static {
        factory.setNamespaceAware(false);
        factory.setValidating(false);
    }
}

