/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.listeners;

import java.io.CharArrayWriter;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.config.ChRISConfig;
import uk.gov.hmrc.chris.utils.config.ChRISNode;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.envelopeGenerators.MappedErrorResponseGenerator;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class UserErrorsMapper
implements Listener {
    private static final String MAPPING_NAMESPACE = "http://www.hmrc.gov.uk/internal/servicemapping/1";
    private XMLBuilder builder;
    private MappedErrorResponseGenerator errorBuilder;
    private ChRISNode config;
    private CharArrayWriter chars = new CharArrayWriter(30);
    private String raisedBy;
    private String number;
    private String type;
    private String text;
    private String location;
    private int errorCount;
    private int maxErrors;
    private String developerMessage;
    private static final String ERROR_NODE = "Error";
    private static final String LOCATION_NODE = "Location";
    private static final String RAISED_BY_NODE = "RaisedBy";
    private static final String TYPE_NODE = "Type";
    private static final String NUMBER_NODE = "Number";
    private static final String TEXT_NODE = "Text";
    private static final String DEVELOPERMESSAGE_NODE = "DeveloperMessage";

    public UserErrorsMapper(XMLBuilder builder, String formAttribute) {
        ChRISNode[] nodes = ChRISConfig.getNodes(MAPPING_NAMESPACE);
        for (int x = 0; x < nodes.length; ++x) {
            if (!nodes[x].getAttributeValue("form").equals(formAttribute)) continue;
            this.config = nodes[x];
            this.builder = builder;
            break;
        }
        if (this.config == null) {
            throw new SPOXException("Could not fine mapping file.  Using namespace : http://www.hmrc.gov.uk/internal/servicemapping/1 and form attribute " + formAttribute);
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    @Override
    public void characterDataFound(char[] data, int Size) throws SPOXException {
        this.chars.write(data, 0, Size);
    }

    @Override
    public void documentFinished() throws SPOXException {
    }

    @Override
    public void documentStarted() throws SPOXException {
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        if (this.maxErrors != -1 && this.errorCount >= this.maxErrors) {
            return;
        }
        if (name.equals(ERROR_NODE)) {
            this.errorBuilder.setRaisedBy(this.raisedBy);
            this.errorBuilder.setType(this.type);
            try {
                String strippedLocation = this.location.replaceAll("\\[\\d+\\]", "");
                ChRISNode node = this.config.getXPath("Error[@xpath='" + strippedLocation + "']");
                if (node != null) {
                    ChRISNode numberNode;
                    ChRISNode locationNode = node.getXPath(LOCATION_NODE);
                    if (locationNode != null) {
                        this.errorBuilder.setMapLocation(locationNode.getValue());
                    }
                    if ((numberNode = node.getXPath("ErrorNumbers/Number[@id='" + this.number + "']")) != null) {
                        ChRISNode userText;
                        ChRISNode userNumber = numberNode.getXPath("UserCode");
                        if (userNumber != null) {
                            this.errorBuilder.setMapNumber(Integer.parseInt(userNumber.getValue()));
                        }
                        if ((userText = numberNode.getXPath("UserText")) != null) {
                            this.errorBuilder.setMapText(userText.getValue());
                        }
                    }
                } else {
                    ChRISNode numberNode = this.config.getXPath("GlobalErrors/GlobalError[@id='" + this.number + "']");
                    if (numberNode != null) {
                        ChRISNode userText;
                        ChRISNode userNumber = numberNode.getXPath("UserCode");
                        if (userNumber != null) {
                            this.errorBuilder.setNumber(Integer.parseInt(userNumber.getValue()));
                        }
                        if ((userText = numberNode.getXPath("UserText")) != null) {
                            this.errorBuilder.setText(userText.getValue());
                        }
                    }
                }
                this.errorBuilder.setDeveloperMessage(this.developerMessage);
                this.errorBuilder.setLocation(this.location);
                this.errorBuilder.setText(this.text);
                this.errorBuilder.setNumber(Integer.parseInt(this.number));
                ++this.errorCount;
                this.errorBuilder.generate(this.builder);
            }
            catch (EnvelopeGeneratorException e) {
                throw new SPOXException("Could not generate mapped error document", e);
            }
        } else if (name.equals(RAISED_BY_NODE)) {
            this.raisedBy = this.chars.toString();
        } else if (name.equals(NUMBER_NODE)) {
            this.number = this.chars.toString();
        } else if (name.equals(TYPE_NODE)) {
            this.type = this.chars.toString();
        } else if (name.equals(TEXT_NODE)) {
            this.text = this.chars.toString();
        } else if (name.equals(LOCATION_NODE)) {
            this.location = this.chars.toString();
        } else if (name.equals(DEVELOPERMESSAGE_NODE)) {
            this.developerMessage = this.chars.toString();
        }
    }

    @Override
    public String getNameSpace() throws SPOXException {
        return null;
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return new String[]{"Errors/Error"};
    }

    @Override
    public void nameSpaceFinished() throws SPOXException {
    }

    @Override
    public void nameSpaceFound() throws SPOXException {
    }

    @Override
    public void reset() throws SPOXException {
    }

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        this.chars.reset();
        if (name.equals(ERROR_NODE)) {
            this.errorBuilder = new MappedErrorResponseGenerator();
        }
    }

    @Override
    public void xpathFinished() throws SPOXException {
    }

    @Override
    public void xpathFound(String xpath) throws SPOXException {
    }

    @Override
    public void commentFound(char[] arg0, int start, int length) {
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }
}

