/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.hmrc.chris.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.listeners.processing.NodeModifier;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.config.ChRISNode;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class XMLDataItemsExtractor
extends DefaultListener {
    protected boolean dataToProcess = false;
    protected XMLBuilder builder = null;
    protected boolean inSideXpath = false;
    protected NodeModifier modifier;
    protected List<String> xPaths = new ArrayList<String>();
    protected Map<String, String> results = new HashMap<String, String>();

    public XMLDataItemsExtractor(ChRISNode xpaths, NodeModifier modfier) {
        ChRISNode[] xPathElements = xpaths.getXPaths("Xpaths/Xpath");
        this.modifier = modfier;
        for (ChRISNode node : xPathElements) {
            this.xPaths.add(node.getValue());
        }
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        if (this.inSideXpath) {
            try {
                this.builder.writeEndElement();
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Unable to write to the output stream", e);
            }
        }
    }

    @Override
    public void characterDataFound(char[] data, int size) throws SPOXException {
        if (this.inSideXpath) {
            try {
                this.builder.writeText(new String(data, 0, size));
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Unable to write to the output stream", e);
            }
        }
    }

    @Override
    public void xpathFound(String xpath) throws SPOXException {
        if (this.xPaths.contains(xpath)) {
            this.inSideXpath = true;
        }
    }

    @Override
    public void xpathFinished() {
        this.inSideXpath = false;
    }

    @Override
    public void documentFinished() throws SPOXException {
    }

    @Override
    public void documentStarted() throws SPOXException {
        this.startWriter();
    }

    protected void startWriter() throws SPOXException {
        try {
            this.builder = new XMLBuilder(false);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Unable to write to the output stream", e);
        }
    }

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        if (this.inSideXpath) {
            String finalName = this.checkForModification(name);
            this.dataToProcess = true;
            try {
                this.builder.writeStartElement(finalName);
                boolean ignoreAttributes = this.checkIfIgnoreAllAttributes(name);
                if (!ignoreAttributes) {
                    for (Attribute attr : attributes) {
                        this.builder.writeAttribute(attr.getName(), attr.getValue());
                    }
                }
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Unable to write the start element to the writer");
            }
        }
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return this.xPaths.toArray(new String[0]);
    }

    @Override
    public Object getResults() {
        try {
            return this.builder.getBytesAsNewData();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Exception Happened while processing results", e);
        }
    }

    private String checkForModification(String name) {
        if (this.modifier == null) {
            return name;
        }
        return this.modifier.checkForModification(name);
    }

    private boolean checkIfIgnoreAllAttributes(String nodeName) {
        if (this.modifier == null) {
            return false;
        }
        return this.modifier.checkIfIgnoreAllAttributes(nodeName);
    }
}

